/*
 * Decompiled with CFR 0.152.
 */
package com.outsystems.plugins.barcode.controller;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.camera.core.ImageProxy;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.outsystems.plugins.barcode.controller.OSBARCScanLibraryInterface;
import com.outsystems.plugins.barcode.controller.helper.OSBARCMLKitHelperInterface;
import com.outsystems.plugins.barcode.model.OSBARCError;
import com.outsystems.plugins.barcode.model.OSBARCScanResult;
import com.outsystems.plugins.barcode.model.OSBARCScannerHint;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J@\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\fH\u0016J\u0013\u0010\u0010\u001a\u00020\u0011*\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/outsystems/plugins/barcode/controller/OSBARCMLKitWrapper;", "Lcom/outsystems/plugins/barcode/controller/OSBARCScanLibraryInterface;", "helper", "Lcom/outsystems/plugins/barcode/controller/helper/OSBARCMLKitHelperInterface;", "(Lcom/outsystems/plugins/barcode/controller/helper/OSBARCMLKitHelperInterface;)V", "scanBarcode", "", "imageProxy", "Landroidx/camera/core/ImageProxy;", "imageBitmap", "Landroid/graphics/Bitmap;", "onSuccess", "Lkotlin/Function1;", "Lcom/outsystems/plugins/barcode/model/OSBARCScanResult;", "onError", "Lcom/outsystems/plugins/barcode/model/OSBARCError;", "toOSBARCScannerHint", "Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;", "", "(Ljava/lang/Integer;)Lcom/outsystems/plugins/barcode/model/OSBARCScannerHint;", "Companion", "OSBarcodeLib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nOSBARCMLKitWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSBARCMLKitWrapper.kt\ncom/outsystems/plugins/barcode/controller/OSBARCMLKitWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class OSBARCMLKitWrapper
implements OSBARCScanLibraryInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OSBARCMLKitHelperInterface helper;
    public static final int $stable = 8;
    @NotNull
    private static final String LOG_TAG = "OSBARCMLKitWrapper";

    public OSBARCMLKitWrapper(@NotNull OSBARCMLKitHelperInterface helper) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        this.helper = helper;
    }

    @Override
    public void scanBarcode(@NotNull ImageProxy imageProxy, @NotNull Bitmap imageBitmap, @NotNull Function1<? super OSBARCScanResult, Unit> onSuccess, @NotNull Function1<? super OSBARCError, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        Intrinsics.checkNotNullParameter((Object)imageBitmap, (String)"imageBitmap");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        try {
            this.helper.decodeImage(imageProxy, imageBitmap, (Function1<? super List<Barcode>, Unit>)((Function1)new Function1<List<Barcode>, Unit>(this, onSuccess){
                final /* synthetic */ OSBARCMLKitWrapper this$0;
                final /* synthetic */ Function1<OSBARCScanResult, Unit> $onSuccess;
                {
                    this.this$0 = $receiver;
                    this.$onSuccess = $onSuccess;
                    super(1);
                }

                public final void invoke(@NotNull List<Barcode> barcodes) {
                    block2: {
                        Intrinsics.checkNotNullParameter(barcodes, (String)"barcodes");
                        Barcode barcode = (Barcode)CollectionsKt.firstOrNull(barcodes);
                        if (barcode == null) break block2;
                        Barcode barcode2 = barcode;
                        OSBARCMLKitWrapper oSBARCMLKitWrapper = this.this$0;
                        Function1<OSBARCScanResult, Unit> function1 = this.$onSuccess;
                        Barcode barcode3 = barcode2;
                        boolean bl = false;
                        String string = barcode3.getRawValue();
                        if (string == null) {
                            string = "";
                        }
                        String string2 = string;
                        Intrinsics.checkNotNull((Object)string2);
                        OSBARCScanResult result = new OSBARCScanResult(string2, OSBARCMLKitWrapper.access$toOSBARCScannerHint(oSBARCMLKitWrapper, barcode3.getFormat()));
                        if (((CharSequence)result.getText()).length() > 0) {
                            function1.invoke((Object)result);
                        }
                    }
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>(onError){
                final /* synthetic */ Function1<OSBARCError, Unit> $onError;
                {
                    this.$onError = $onError;
                    super(0);
                }

                public final void invoke() {
                    this.$onError.invoke((Object)((Object)OSBARCError.MLKIT_LIBRARY_ERROR));
                }
            }));
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Log.e((String)LOG_TAG, (String)it);
            }
            onError.invoke((Object)OSBARCError.MLKIT_LIBRARY_ERROR);
        }
    }

    private final OSBARCScannerHint toOSBARCScannerHint(Integer $this$toOSBARCScannerHint) {
        OSBARCScannerHint oSBARCScannerHint;
        Integer n;
        Integer n2 = n = $this$toOSBARCScannerHint;
        int n3 = 256;
        if (n2 != null && n2 == n3) {
            oSBARCScannerHint = OSBARCScannerHint.QR_CODE;
        } else {
            Integer n4 = n;
            n3 = 4096;
            if (n4 != null && n4 == n3) {
                oSBARCScannerHint = OSBARCScannerHint.AZTEC;
            } else {
                Integer n5 = n;
                n3 = 8;
                if (n5 != null && n5 == n3) {
                    oSBARCScannerHint = OSBARCScannerHint.CODABAR;
                } else {
                    Integer n6 = n;
                    n3 = 2;
                    if (n6 != null && n6 == n3) {
                        oSBARCScannerHint = OSBARCScannerHint.CODE_39;
                    } else {
                        Integer n7 = n;
                        n3 = 4;
                        if (n7 != null && n7 == n3) {
                            oSBARCScannerHint = OSBARCScannerHint.CODE_93;
                        } else {
                            Integer n8 = n;
                            n3 = 1;
                            if (n8 != null && n8 == n3) {
                                oSBARCScannerHint = OSBARCScannerHint.CODE_128;
                            } else {
                                Integer n9 = n;
                                n3 = 16;
                                if (n9 != null && n9 == n3) {
                                    oSBARCScannerHint = OSBARCScannerHint.DATA_MATRIX;
                                } else {
                                    Integer n10 = n;
                                    n3 = 128;
                                    if (n10 != null && n10 == n3) {
                                        oSBARCScannerHint = OSBARCScannerHint.ITF;
                                    } else {
                                        Integer n11 = n;
                                        n3 = 32;
                                        if (n11 != null && n11 == n3) {
                                            oSBARCScannerHint = OSBARCScannerHint.EAN_13;
                                        } else {
                                            Integer n12 = n;
                                            n3 = 64;
                                            if (n12 != null && n12 == n3) {
                                                oSBARCScannerHint = OSBARCScannerHint.EAN_8;
                                            } else {
                                                Integer n13 = n;
                                                n3 = 2048;
                                                if (n13 != null && n13 == n3) {
                                                    oSBARCScannerHint = OSBARCScannerHint.PDF_417;
                                                } else {
                                                    Integer n14 = n;
                                                    n3 = 512;
                                                    if (n14 != null && n14 == n3) {
                                                        oSBARCScannerHint = OSBARCScannerHint.UPC_A;
                                                    } else {
                                                        Integer n15 = n;
                                                        n3 = 1024;
                                                        oSBARCScannerHint = n15 != null && n15 == n3 ? OSBARCScannerHint.UPC_E : OSBARCScannerHint.UNKNOWN;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return oSBARCScannerHint;
    }

    public static final /* synthetic */ OSBARCScannerHint access$toOSBARCScannerHint(OSBARCMLKitWrapper $this, Integer $receiver) {
        return $this.toOSBARCScannerHint($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/outsystems/plugins/barcode/controller/OSBARCMLKitWrapper$Companion;", "", "()V", "LOG_TAG", "", "OSBarcodeLib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

