/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.intercom.api.Reply;
import io.intercom.api.User;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class UserReply
extends Reply<User> {
    public UserReply(User user) {
        this.from = user;
    }

    @Override
    public String toString() {
        return "UserReply{} " + super.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static class UserStringReply {
        private UserReply reply;

        public UserStringReply(UserReply reply) {
            this.reply = reply;
        }

        @JsonProperty(value="type")
        public String getType() {
            return this.reply.getType();
        }

        @JsonProperty(value="message_type")
        public String getMessageType() {
            return "comment";
        }

        @JsonProperty(value="body")
        public String getBody() {
            return this.reply.getBody();
        }

        @JsonProperty(value="intercom_user_id")
        public String getIntercomUserID() {
            return ((User)this.reply.getFrom()).getId();
        }

        @JsonProperty(value="user_id")
        public String getUserID() {
            return ((User)this.reply.getFrom()).getUserId();
        }

        @JsonProperty(value="email")
        public String getEmail() {
            return ((User)this.reply.getFrom()).getEmail();
        }

        @JsonProperty(value="attachment_urls")
        private String[] getAttachmentUrls() {
            return this.reply.getAttachmentUrls();
        }
    }
}

