/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.intercom.api.Conditions;
import io.intercom.api.Error;
import io.intercom.api.TypedData;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class JobItem<T extends TypedData>
extends TypedData {
    @JsonProperty(value="type")
    private final String type = "job_item";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="method")
    private String method;
    @JsonProperty(value="data_type")
    private String dataType;
    @JsonProperty(value="error")
    private Error error;
    @JsonProperty(value="data")
    private T data;

    public JobItem() {
    }

    public JobItem(String method, T data) {
        this(method, data, null);
    }

    JobItem(String method, T data, String dataType) {
        Conditions.checkNotNull(method, "item method must be supplied");
        Conditions.checkNotNull(data, "item data must be supplied");
        this.method = method;
        this.data = data;
        this.dataType = dataType;
        if (dataType == null) {
            this.dataType = ((TypedData)data).getType();
        }
        Conditions.checkNotNull(data, "item dataType must be supplied");
    }

    @Override
    public String getType() {
        return "job_item";
    }

    public String getID() {
        return this.id;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getMethod() {
        return this.method;
    }

    public JobItem<T> setMethod(String method) {
        this.method = method;
        return this;
    }

    public Error getError() {
        return this.error;
    }

    public T getData() {
        return this.data;
    }

    public JobItem<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String toString() {
        return "JobItem{type='job_item', id='" + this.id + '\'' + ", updatedAt=" + this.updatedAt + ", method='" + this.method + '\'' + ", dataType='" + this.dataType + '\'' + ", error=" + this.error + ", data=" + this.data + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobItem jobItem = (JobItem)o;
        if (this.updatedAt != jobItem.updatedAt) {
            return false;
        }
        if ("job_item" != null ? !"job_item".equals(jobItem.type) : jobItem.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(jobItem.id) : jobItem.id != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(jobItem.method) : jobItem.method != null) {
            return false;
        }
        if (this.dataType != null ? !this.dataType.equals(jobItem.dataType) : jobItem.dataType != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(jobItem.error) : jobItem.error != null) {
            return false;
        }
        return !(this.data == null ? jobItem.data != null : !this.data.equals(jobItem.data));
    }

    public int hashCode() {
        int result = "job_item" != null ? "job_item".hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }
}

