/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.ClientException;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.JobItem;
import io.intercom.api.JobItemCollection;
import io.intercom.api.JobItemRequest;
import io.intercom.api.JobTask;
import io.intercom.api.MapperSupport;
import io.intercom.api.RateLimitException;
import io.intercom.api.ServerException;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Job
extends TypedData {
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "job";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="app_id")
    private String appID;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="completed_at")
    private long completedAt;
    @JsonProperty(value="closing_at")
    private long closingAt;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="tasks")
    private List<JobTask> tasks;
    @JsonProperty(value="links")
    private Map<String, URI> links;

    public static Job find(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return Job.find(id, SENTINEL);
    }

    public static Job find(String id, Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return new HttpClient(UriBuilder.newBuilder().path("jobs").path(id).query(params).build()).get(Job.class);
    }

    public static Job update(Job job) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.post(job, UriBuilder.newBuilder().path("jobs").path(job.getID()).build(), Job.class);
    }

    static <T extends TypedData> Job submit(List<JobItem<T>> items, List<String> bulkPaths) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return Job.submit(items, null, bulkPaths);
    }

    static <T extends TypedData> Job submit(List<JobItem<T>> items, Job job, List<String> bulkPaths) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.create(new JobItemRequest<T>(items, job), bulkPaths, Job.class);
    }

    static <T extends TypedData> JobItemCollection<T> listJobErrorFeed(String jobID, Class<T> c) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        URI feedURI = UriBuilder.newBuilder().path("jobs").path(jobID).path("error").build();
        HttpClient resource = new HttpClient(feedURI);
        TypeReference typeReference = new TypeReference<JobItemCollection<T>>(){};
        JavaType type = MapperSupport.objectMapper().getTypeFactory().constructParametricType(JobItemCollection.class, new Class[]{c});
        return (JobItemCollection)resource.get(type);
    }

    @Override
    public String getType() {
        return "job";
    }

    public String getID() {
        return this.id;
    }

    public Job setID(String id) {
        this.id = id;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public long getCompletedAt() {
        return this.completedAt;
    }

    public String getName() {
        return this.name;
    }

    public Job setName(String name) {
        this.name = name;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public String getAppID() {
        return this.appID;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public long getClosingAt() {
        return this.closingAt;
    }

    public Job setClosingAt(long closingAt) {
        this.closingAt = closingAt;
        return this;
    }

    public List<JobTask> getTasks() {
        return this.tasks;
    }

    public String toString() {
        return "Job{type='job', id='" + this.id + '\'' + ", appID='" + this.appID + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", completedAt=" + this.completedAt + ", name='" + this.name + '\'' + ", state='" + this.state + '\'' + ", links=" + this.links + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.createdAt != job.createdAt) {
            return false;
        }
        if (this.updatedAt != job.updatedAt) {
            return false;
        }
        if (this.completedAt != job.completedAt) {
            return false;
        }
        if ("job" != null ? !"job".equals(job.type) : job.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(job.id) : job.id != null) {
            return false;
        }
        if (this.appID != null ? !this.appID.equals(job.appID) : job.appID != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(job.name) : job.name != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(job.state) : job.state != null) {
            return false;
        }
        return !(this.links == null ? job.links != null : !this.links.equals(job.links));
    }

    public int hashCode() {
        int result = "job" != null ? "job".hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.appID != null ? this.appID.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (int)(this.completedAt ^ this.completedAt >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }
}

