package io.intercom.android.nexus;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import javax.annotation.Nonnull;
import javax.annotation.meta.TypeQualifierDefault;

/**
 * Mark all parameters, fields, and return values in a package or class as {@link Nonnull} unless overridden with a
 * {@link javax.annotation.Nullable}, {@link javax.annotation.CheckForNull}
 * or {@link androidx.annotation.NonNull} annotation.
 */
@Documented
@Nonnull
@TypeQualifierDefault({ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.SOURCE)
@interface EverythingIsNonnullByDefault {
}

