/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Attachment;
import io.intercom.android.sdk.blocks.Button;
import io.intercom.android.sdk.blocks.Code;
import io.intercom.android.sdk.blocks.Facebook;
import io.intercom.android.sdk.blocks.Heading;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.LightWeightReply;
import io.intercom.android.sdk.blocks.OrderedList;
import io.intercom.android.sdk.blocks.Paragraph;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.Subheading;
import io.intercom.android.sdk.blocks.Twitter;
import io.intercom.android.sdk.blocks.UnorderedList;
import io.intercom.android.sdk.blocks.Video;
import io.intercom.android.sdk.interfaces.LWRListener;
import io.intercom.blocks.BlocksViewHolder;
import io.intercom.blocks.blockInterfaces.AttachmentBlock;
import io.intercom.blocks.blockInterfaces.ButtonBlock;
import io.intercom.blocks.blockInterfaces.CodeBlock;
import io.intercom.blocks.blockInterfaces.FacebookBlock;
import io.intercom.blocks.blockInterfaces.HeadingBlock;
import io.intercom.blocks.blockInterfaces.ImageBlock;
import io.intercom.blocks.blockInterfaces.LightWeightReplyBlock;
import io.intercom.blocks.blockInterfaces.OrderedListBlock;
import io.intercom.blocks.blockInterfaces.ParagraphBlock;
import io.intercom.blocks.blockInterfaces.SubheadngBlock;
import io.intercom.blocks.blockInterfaces.TwitterBlock;
import io.intercom.blocks.blockInterfaces.UnorderedListBlock;
import io.intercom.blocks.blockInterfaces.VideoBlock;

public class ViewHolderGenerator {
    private final Context context;

    public ViewHolderGenerator(Context context) {
        this.context = context;
    }

    public BlocksViewHolder getAdminHolder(LWRListener listener) {
        return this.generateHolder(R.layout.intercomsdk_blocks_admin_layout, StyleType.admin, listener);
    }

    public BlocksViewHolder getAnnouncementLWRHolder(LWRListener listener) {
        return this.generateHolder(R.layout.intercomsdk_blocks_announcement_lwr_layout, StyleType.announcement, listener);
    }

    public BlocksViewHolder getUserHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_user_layout, StyleType.user);
    }

    public BlocksViewHolder getPreviewHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_user_layout, StyleType.preview);
    }

    public BlocksViewHolder getAnnouncementHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_announcement_layout, StyleType.announcement);
    }

    public BlocksViewHolder getWelcomeHolder() {
        return this.generateHolder(R.layout.intercomsdk_blocks_welcome_layout, StyleType.welcome);
    }

    private BlocksViewHolder generateHolder(int layoutId, StyleType style) {
        return this.generateHolder(layoutId, style, null);
    }

    private BlocksViewHolder generateHolder(int layoutId, StyleType style, LWRListener listener) {
        BlocksViewHolder holder = new BlocksViewHolder();
        holder.setLayout(layoutId);
        holder.setParagraph((ParagraphBlock)new Paragraph(this.context, style));
        holder.setHeading((HeadingBlock)new Heading(this.context, style));
        holder.setSubheading((SubheadngBlock)new Subheading(this.context, style));
        holder.setCode((CodeBlock)new Code(this.context, style));
        holder.setUnorderedList((UnorderedListBlock)new UnorderedList(this.context, style));
        holder.setOrderedList((OrderedListBlock)new OrderedList(this.context, style));
        holder.setImage((ImageBlock)new Image(this.context, style));
        holder.setButton((ButtonBlock)new Button(this.context, style));
        holder.setAttachment((AttachmentBlock)new Attachment(this.context, style));
        holder.setTwitterButton((TwitterBlock)new Twitter(this.context, style));
        holder.setFacebookButton((FacebookBlock)new Facebook(this.context, style));
        holder.setVideo((VideoBlock)new Video(this.context, style));
        holder.setLwr((LightWeightReplyBlock)new LightWeightReply(this.context, style, listener));
        return holder;
    }
}

