/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.CertificatePinner;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.annotations.IntercomExclusionStrategy;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.IntercomApiInterface;
import io.intercom.android.sdk.api.MainThreadBus;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.APIModels.Part;
import io.intercom.android.sdk.models.APIModels.ReadResponse;
import io.intercom.android.sdk.models.APIModels.UsersResponse;
import io.intercom.android.sdk.user.DeviceData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class Api {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String BASE_URL = "https://mobileapi-v2.intercom.io/";
    private static final String HOSTNAME = "mobileapi-v2.intercom.io";
    private static final int MAX_RETRY_COUNT = 3;
    private static final int INITIAL_RETRY_COUNT = 1;
    private static final String VERSION_NUMBER = "0.9.3";
    private static final int CACHE_SIZE = 0xA00000;
    private final IntercomApiInterface intercomApiInterface;
    private final CallbackHolder callbacks;
    private final Handler retryHandler;

    public Api(Context context, MainThreadBus bus) {
        File cacheDirectory = new File(context.getCacheDir().getAbsolutePath(), CACHE_NAME);
        OkHttpClient client = new OkHttpClient();
        client.setCache(new Cache(cacheDirectory, 0xA00000L));
        CertificatePinner certificatePinner = new CertificatePinner.Builder().add(HOSTNAME, new String[]{"sha1/UA4GILe/aHSG/Rz3kv9TYrkQOQk="}).add(HOSTNAME, new String[]{"sha1/UbxPdxcIz+UJ3enqpVSOkcBneFM="}).add(HOSTNAME, new String[]{"sha1/1S4TwavjSdrotJWU73w4Q2BkZr0="}).build();
        client.setCertificatePinner(certificatePinner);
        client.interceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                IdentityStore identityStore = Bridge.getIdentityStore();
                if (identityStore.userIdentityExists() && identityStore.appIdentityExists()) {
                    String fingerprint = identityStore.getUserIdentityFingerprint();
                    Response response = chain.proceed(chain.request());
                    if (fingerprint.equals(identityStore.getUserIdentityFingerprint())) {
                        Logger.INTERNAL("interceptor", "proceeding");
                        return response;
                    }
                    Logger.INTERNAL("interceptor", "halting: user identity changed");
                    return null;
                }
                Logger.INTERNAL("interceptor", "halting: no user or app identity");
                return null;
            }
        });
        RequestInterceptor requestInterceptor = new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Accept", "application/vnd.intercom.3C+json");
                request.addHeader("Content-Type", "application/json");
                request.addHeader("X-INTERCOM-AGENT", "intercom-android-sdk/0.9.3");
            }
        };
        Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new IntercomExclusionStrategy()}).create();
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(BASE_URL).setClient((Client)new OkClient(client)).setConverter((Converter)new GsonConverter(gson)).setRequestInterceptor(requestInterceptor).build();
        this.intercomApiInterface = (IntercomApiInterface)restAdapter.create(IntercomApiInterface.class);
        this.callbacks = new CallbackHolder();
        bus.register(this.callbacks);
        this.retryHandler = new Handler();
    }

    public void registerUnidentifiedUser() {
        this.updateUser(new HashMap<String, Object>(), DeviceData.generateDeviceData(Bridge.getContext()), true, 1);
    }

    public void registerIdentifiedUser(Registration registration) {
        HashMap<String, Object> deviceData = DeviceData.generateDeviceData(Bridge.getContext());
        if (!registration.getRegistrationId().isEmpty()) {
            deviceData.put("device_token", registration.getRegistrationId());
        }
        this.updateUser(registration.getAttributes(), deviceData, true, 1);
    }

    public void ping() {
        this.updateUser(new HashMap<String, Object>(), DeviceData.generateDeviceData(Bridge.getContext()), true, 1);
    }

    public void setGCMPushKey(String gcmRegistrationId) {
        HashMap<String, Object> deviceData = DeviceData.generateDeviceData(Bridge.getContext());
        deviceData.put("device_token", gcmRegistrationId);
        this.updateUser(new HashMap<String, Object>(), deviceData, false, 1);
    }

    public void updateUser(Map<String, Object> attributes) {
        this.updateUser(attributes, DeviceData.generateDeviceData(Bridge.getContext()), false, 1);
    }

    private void updateUser(final Map<String, Object> attributes, final Map<String, Object> deviceData, final boolean newSession, final int retryCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", Bridge.getIdentityStore().getUserMap());
        params.put("device_data", deviceData);
        params.put("new_session", newSession);
        if (!attributes.isEmpty()) {
            params.put("user_attributes", attributes);
        }
        this.addSecureHash(params);
        this.intercomApiInterface.updateUser(this.getBasicAuth(), params, new retrofit.Callback<UsersResponse.Builder>(){

            public void success(UsersResponse.Builder builder, retrofit.client.Response response) {
                Logger.INFO("Successfully registered or updated user");
                Api.this.callbacks.unreadCallback().success((Object)builder, response);
            }

            public void failure(RetrofitError error) {
                if (error.getResponse() != null) {
                    Logger.ERROR("Failed to register or update user: network error - " + error.getResponse().getStatus() + " " + error.getResponse().getReason());
                }
                if (retryCount <= 3 && Api.this.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.updateUser(attributes, deviceData, newSession, retryCount + 1);
                        }
                    }, (long)Api.this.retryTimer(retryCount));
                }
            }
        });
    }

    public void logEvent(String name, Map<String, Object> metaData) {
        this.logEvent(name, metaData, 1);
    }

    private void logEvent(final String name, final Map<String, Object> metaData, final int retryCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.put("user", Bridge.getIdentityStore().getUserMap());
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        params.put("event", eventParams);
        this.addSecureHash(params);
        this.intercomApiInterface.logEvent(this.getBasicAuth(), params, new retrofit.Callback<UsersResponse.Builder>(){

            public void success(UsersResponse.Builder builder, retrofit.client.Response response) {
                Logger.INFO("Successfully logged event");
                Api.this.callbacks.unreadCallback().success((Object)builder, response);
            }

            public void failure(RetrofitError error) {
                if (error.getResponse() != null) {
                    Logger.ERROR("Failed to log event: network error - " + error.getResponse().getStatus() + " " + error.getResponse().getReason());
                }
                if (retryCount <= 3 && Api.this.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.logEvent(name, metaData, retryCount + 1);
                        }
                    }, (long)Api.this.retryTimer(retryCount));
                }
            }
        });
    }

    public void markConversationAsRead(String conversationId) {
        this.markAsRead(conversationId, 1);
    }

    private void markAsRead(final String conversationId, final int retryCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("user", Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.markAsRead(conversationId, this.getBasicAuth(), params, new retrofit.Callback<ReadResponse.Builder>(){

            public void success(ReadResponse.Builder builder, retrofit.client.Response response) {
                Logger.INTERNAL("API Success", "Successfully marked as read");
                Api.this.callbacks.readCallback(conversationId).success((Object)builder, response);
            }

            public void failure(RetrofitError error) {
                if (error.getResponse() != null) {
                    Logger.INTERNAL("API ERROR", "Failed to mark conversation as read" + error.getResponse().getStatus() + " " + error.getResponse().getReason());
                }
                if (retryCount <= 3 && Api.this.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.markAsRead(conversationId, retryCount + 1);
                        }
                    }, (long)Api.this.retryTimer(retryCount));
                }
            }
        });
    }

    public void sendLWRResponse(String conversationId, String replyType, String replyOption) {
        this.sendLWRResponse(conversationId, replyType, replyOption, 1);
    }

    public void sendLWRResponse(final String conversationId, final String replyType, final String replyOption, final int retryCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reply_type", replyType);
        params.put("reply_option", replyOption);
        params.put("user", Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, this.getBasicAuth(), params, new retrofit.Callback<Part.Builder>(){

            public void success(Part.Builder builder, retrofit.client.Response response) {
                Logger.INTERNAL("API Success", "Successfully sent LWR");
            }

            public void failure(RetrofitError error) {
                if (error.getResponse() != null) {
                    Logger.INTERNAL("API ERROR", "Failed to send LWR: " + error.getResponse().getStatus() + " " + error.getResponse().getReason());
                }
                if (retryCount <= 3 && Api.this.isRetriable(error)) {
                    Api.this.retryHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Api.this.sendLWRResponse(conversationId, replyType, replyOption, retryCount + 1);
                        }
                    }, (long)Api.this.retryTimer(retryCount));
                }
            }
        });
    }

    public void getInbox() {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(this.getBasicAuth(), params, this.callbacks.inboxCallback());
    }

    public void getInboxBefore(long before) {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("before", String.valueOf(before));
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(this.getBasicAuth(), params, this.callbacks.inboxCallback());
    }

    public void getUnreadConversations() {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getUnreadConversations(this.getBasicAuth(), params, this.callbacks.unreadCallback());
    }

    public void getConversation(String conversationId) {
        Map<String, Object> params = Bridge.getIdentityStore().getUserMap();
        this.addSecureHash(params);
        this.intercomApiInterface.getConversation(conversationId, this.getBasicAuth(), params, this.callbacks.conversationCallback());
    }

    public void replyToConversation(String conversationId, String messageText, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("type", "user");
        params.put("message_type", "comment");
        params.put("body", messageText);
        params.put("user", Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, this.getBasicAuth(), params, this.callbacks.replyCallback(tempPartPosition, tempPartId));
    }

    public void startNewConversation(String messageText, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", Bridge.getIdentityStore().getAppId());
        params.put("body", messageText);
        params.put("user", Bridge.getIdentityStore().getUserMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(this.getBasicAuth(), params, this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void getVideo(String url, Callback callback) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        new OkHttpClient().newCall(new Request.Builder().url(url).build()).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                Logger.INTERNAL("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(Response response) throws IOException {
            }
        });
    }

    private int retryTimer(int count) {
        return (int)(Math.pow(2.0, count) * 1000.0);
    }

    private boolean isRetriable(RetrofitError error) {
        if (error.getResponse() != null) {
            int status = error.getResponse().getStatus();
            return status < 400 || status >= 500;
        }
        IdentityStore store = Bridge.getIdentityStore();
        return store.appIdentityExists() && store.userIdentityExists();
    }

    private String getBasicAuth() {
        return "Basic " + Base64.encodeToString((byte[])(Bridge.getIdentityStore().getAppId() + ":" + Bridge.getIdentityStore().getApiKey()).getBytes(), (int)2);
    }

    private void addSecureHash(Map<String, Object> params) {
        IdentityStore identityStore = Bridge.getIdentityStore();
        String secureData = identityStore.getData();
        String secureHmac = identityStore.getHmac();
        if (!TextUtils.isEmpty((CharSequence)secureData) && !TextUtils.isEmpty((CharSequence)secureHmac)) {
            params.put("data", secureData);
            params.put("hmac", secureHmac);
        }
    }
}

