/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Html;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import io.intercom.blocks.blockInterfaces.UnorderedListBlock;
import java.util.List;

public class UnorderedList
implements UnorderedListBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public UnorderedList(Context context, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addUnorderedList(List<String> items, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        LinearLayout layout2 = new LinearLayout(this.context);
        switch (this.style) {
            case admin: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_unorderedlist, parent, false);
                break;
            }
            case announcement: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_unorderedlist, parent, false);
                break;
            }
            case welcome: {
                layout2 = (LinearLayout)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_list, parent, false);
                textview = (TextView)layout2.findViewById(R.id.list);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_unorderedlist, parent, false);
            }
        }
        String text = "";
        for (String item : items) {
            text = text + "&#8226;" + item + "<br/>";
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)Html.fromHtml((String)text));
        textview.setLinkTextColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        if (isLastObject) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(textview.getLayoutParams());
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, 0);
            params.gravity = 0x800003;
            textview.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (StyleType.welcome == this.style) {
            return layout2;
        }
        return textview;
    }
}

