/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.Html;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import io.intercom.blocks.blockInterfaces.HeadingBlock;

public class Heading
implements HeadingBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Typeface font;

    public Heading(Context context, StyleType style) {
        this.inflater = LayoutInflater.from((Context)context);
        this.style = style;
        this.font = FontUtils.getTypeface("Roboto-Light.ttf", context);
    }

    public View addHeading(String text, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        switch (this.style) {
            case admin: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_heading, parent, false);
                break;
            }
            case announcement: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_announcement_heading, parent, false);
                int color2 = Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor());
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                textview.setTypeface(this.font);
                break;
            }
            case welcome: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_heading, parent, false);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_heading, parent, false);
            }
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)Html.fromHtml((String)text));
        if (isLastObject) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(textview.getLayoutParams());
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, 0);
            params.gravity = StyleType.announcement == this.style ? 17 : 0x800003;
            textview.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return textview;
    }
}

