/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.os.Handler;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.logger.Logger;
import java.util.concurrent.TimeUnit;

public class PollingManager {
    private final Handler handler = new Handler();
    private final Handler conversationHandler = new Handler();
    private final Runnable chatheadPoller = new Runnable(){

        @Override
        public void run() {
            Logger.INTERNAL("polling", "chathead poll");
            Bridge.getApi().getUnreadConversations();
            PollingManager.this.poll(PollingManager.this.handler, PollingManager.this.chatheadPoller);
        }
    };
    private final Runnable inboxPoller = new Runnable(){

        @Override
        public void run() {
            Logger.INTERNAL("polling", "inbox poll");
            Bridge.getApi().getInbox();
            PollingManager.this.poll(PollingManager.this.handler, PollingManager.this.inboxPoller);
        }
    };
    private Runnable conversationPoller;

    public void startConversationPolling(final String conversationId) {
        Logger.INTERNAL("polling", "starting conversation polling");
        this.conversationPoller = new Runnable(){

            @Override
            public void run() {
                Logger.INTERNAL("polling", "conversation poll");
                Bridge.getApi().getConversation(conversationId);
                PollingManager.this.poll(PollingManager.this.conversationHandler, PollingManager.this.conversationPoller);
            }
        };
        this.poll(this.conversationHandler, this.conversationPoller);
    }

    public void startChatheadPolling() {
        Logger.INTERNAL("polling", "starting chathead polling");
        this.handler.removeCallbacksAndMessages(null);
        this.poll(this.handler, this.chatheadPoller);
    }

    public void startInboxPolling() {
        Logger.INTERNAL("polling", "starting inbox polling");
        this.handler.removeCallbacksAndMessages(null);
        this.poll(this.handler, this.inboxPoller);
    }

    public void endPolling() {
        Logger.INTERNAL("polling", "ending polling");
        this.handler.removeCallbacksAndMessages(null);
        this.conversationHandler.removeCallbacksAndMessages(null);
    }

    public void endConversationPolling() {
        Logger.INTERNAL("polling", "ending conversation polling");
        this.conversationHandler.removeCallbacks(this.conversationPoller);
    }

    private void poll(Handler handler, Runnable poller) {
        handler.postDelayed(poller, TimeUnit.MILLISECONDS.convert(Bridge.getIdentityStore().getAppConfig().getPollingInterval(), TimeUnit.SECONDS));
    }
}

