/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fragment;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.adapters.BlockAdapter;
import io.intercom.android.sdk.blocks.LightWeightReply;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.interfaces.LWRListener;
import io.intercom.android.sdk.interfaces.OnConversationInteractionListener;
import io.intercom.android.sdk.models.APIModels.Part;
import io.intercom.android.sdk.models.APIModels.Participant;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.android.sdk.models.LWR;
import io.intercom.blocks.Blocks;
import io.intercom.blocks.BlocksViewHolder;
import io.intercom.blocks.models.Block;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=15)
public abstract class BaseConversationFragment
extends Fragment
implements LWRListener {
    protected OnConversationInteractionListener listener;
    protected String conversationId;
    protected boolean allowTextReply;
    protected ViewHolderGenerator generator;
    protected BlockAdapter adapter;
    protected Blocks blocks;
    protected List<Part> conversationParts;
    protected int finalRowOffset;
    private BlocksViewHolder blocksUserViewHolder;
    private BlocksViewHolder blocksAnnouncementViewHolder;
    private BlocksViewHolder blocksAdminViewHolder;
    private BlocksViewHolder blocksLWRViewHolder;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.listener = (OnConversationInteractionListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnConversationInteractionListener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bridge.init(this.getActivity().getApplicationContext());
        this.finalRowOffset = Bridge.getIdentityStore().getAppConfig().isShowPoweredBy() ? 1 : 0;
        this.conversationParts = new ArrayList<Part>();
        this.generator = new ViewHolderGenerator((Context)this.getActivity());
        this.blocksUserViewHolder = this.generator.getUserHolder();
        this.blocksAnnouncementViewHolder = this.generator.getAnnouncementHolder();
        this.blocksAdminViewHolder = this.generator.getAdminHolder(this);
        this.blocksLWRViewHolder = this.generator.getAnnouncementLWRHolder(this);
    }

    protected void sanitizeMessage(Part message) {
        List<Block> blocks = message.getBlocks();
        for (int i = blocks.size() - 1; i >= 0; --i) {
            Block block = blocks.get(i);
            if (!block.getType().equals("lwr") && !block.getType().equals("attachment")) continue;
            blocks.remove(block);
        }
    }

    protected Part createMessageUI(Part part) {
        Participant user = part.getParticipant();
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            for (Attachments attachment : part.getAttachments()) {
                Block attachmentBlock = new Block.Builder().build();
                attachmentBlock.setType("attachment");
                attachmentBlock.setText(attachment.getName());
                attachmentBlock.setLinkUrl(attachment.getUrl());
                blockParts.add(attachmentBlock);
            }
        }
        if (!(part.getLightweightReply() instanceof LWR.NullLWR)) {
            Block lwrBlock = new Block.Builder().build();
            lwrBlock.setType("lwr");
            lwrBlock.setText(part.getLightweightReply().getType());
            blockParts.add(lwrBlock);
            LightWeightReply announcementLWR = (LightWeightReply)this.blocksLWRViewHolder.getLwr();
            announcementLWR.setLwrObject(part.getLightweightReply());
            LightWeightReply adminLWR = (LightWeightReply)this.blocksAdminViewHolder.getLwr();
            adminLWR.setLwrObject(part.getLightweightReply());
            this.allowTextReply = false;
        } else {
            this.allowTextReply = true;
        }
        if (!blockParts.isEmpty()) {
            if ("user".equals(user.getType()) && user.getId().equals(Bridge.getIdentityStore().getIntercomId())) {
                part.setLayout(this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
            } else if ("announcement".equals(part.getMessageStyle()) || "small-announcement".equals(part.getMessageStyle())) {
                if (this.allowTextReply) {
                    part.setLayout(this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
                } else {
                    part.setLayout(this.blocks.createBlocks(blockParts, this.blocksLWRViewHolder));
                }
            } else {
                part.setLayout(this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
            }
        }
        return part;
    }

    @Override
    public void sendLWRResponse(LWR lwr) {
        Bridge.getApi().sendLWRResponse(this.conversationId, lwr.getType(), lwr.getOption());
    }

    protected boolean hasWelcomeMessage() {
        return "intercom_welcome_message".equals(this.conversationParts.get(0).getMessageStyle());
    }

    protected void markAsRead() {
        Bridge.getApi().markConversationAsRead(this.conversationId);
    }

    protected void closeTapped() {
        Bridge.getBus().post((Object)new CloseIAMEvent());
    }
}

