/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.ui.common;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import androidx.activity.result.contract.ActivityResultContract;
import io.intercom.android.sdk.ui.common.MediaPickerButtonKt;
import io.intercom.android.sdk.ui.common.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u001b\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u000bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/intercom/android/sdk/ui/common/IntercomMediaPicker;", "Landroidx/activity/result/contract/ActivityResultContract;", "", "", "Landroid/net/Uri;", "mediaType", "Lio/intercom/android/sdk/ui/common/MediaType;", "maxSelectionCount", "", "(Lio/intercom/android/sdk/ui/common/MediaType;I)V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "getAllMimeTypes", "", "()[Ljava/lang/String;", "getDocumentMimeTypes", "getImageMimeTypes", "getIntent", "getNativePickerIntent", "supportedTypes", "([Ljava/lang/String;)Landroid/content/Intent;", "getPhotoPickerIntent", "getVideoMimeTypes", "parseResult", "resultCode", "intent", "getClipDataUris", "intercom-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nMediaPickerButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaPickerButton.kt\nio/intercom/android/sdk/ui/common/IntercomMediaPicker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n3792#2:285\n4307#2,2:286\n3792#2:290\n4307#2,2:291\n3792#2:295\n4307#2,2:296\n37#3,2:288\n37#3,2:293\n37#3,2:298\n37#3,2:313\n1603#4,9:300\n1855#4:309\n1856#4:311\n1612#4:312\n1#5:310\n*S KotlinDebug\n*F\n+ 1 MediaPickerButton.kt\nio/intercom/android/sdk/ui/common/IntercomMediaPicker\n*L\n196#1:285\n196#1:286,2\n199#1:290\n199#1:291,2\n202#1:295\n202#1:296,2\n196#1:288,2\n199#1:293,2\n202#1:298,2\n213#1:313,2\n205#1:300,9\n205#1:309\n205#1:311\n205#1:312\n205#1:310\n*E\n"})
final class IntercomMediaPicker
extends ActivityResultContract<String, List<? extends Uri>> {
    @NotNull
    private final MediaType mediaType;
    private final int maxSelectionCount;

    public IntercomMediaPicker(@NotNull MediaType mediaType, int maxSelectionCount) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        this.mediaType = mediaType;
        this.maxSelectionCount = maxSelectionCount;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.getIntent(input);
    }

    @NotNull
    public List<Uri> parseResult(int resultCode, @Nullable Intent intent) {
        Object object;
        Intent it = object = intent;
        boolean bl = false;
        Intent intent2 = resultCode == -1 ? object : null;
        return intent2 != null && (object = this.getClipDataUris(intent2)) != null ? object : CollectionsKt.emptyList();
    }

    private final Intent getIntent(String input) {
        Intent intent;
        MediaType mediaType = this.mediaType;
        if (mediaType instanceof MediaType.All) {
            Intent intent2 = new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").putExtra("android.intent.extra.MIME_TYPES", (String[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])this.getImageMimeTypes(), (Object[])this.getVideoMimeTypes()), (Object[])this.getDocumentMimeTypes())).setType(input).putExtra("android.intent.extra.ALLOW_MULTIPLE", this.maxSelectionCount > 1);
            intent = intent2;
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"{\n                Intent\u2026nCount > 1)\n            }");
        } else if (mediaType instanceof MediaType.Custom) {
            Intent intent3 = new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").putExtra("android.intent.extra.MIME_TYPES", this.getAllMimeTypes()).setType(input).putExtra("android.intent.extra.ALLOW_MULTIPLE", this.maxSelectionCount > 1);
            intent = intent3;
            Intrinsics.checkNotNullExpressionValue((Object)intent3, (String)"{\n                Intent\u2026nCount > 1)\n            }");
        } else if (mediaType instanceof MediaType.DocumentOnly) {
            intent = this.getNativePickerIntent(this.getDocumentMimeTypes());
        } else if (mediaType instanceof MediaType.ImageAndVideo) {
            intent = MediaPickerButtonKt.isPhotoPickerAvailable() ? this.getPhotoPickerIntent((String[])ArraysKt.plus((Object[])this.getImageMimeTypes(), (Object[])this.getVideoMimeTypes())) : this.getNativePickerIntent((String[])ArraysKt.plus((Object[])this.getImageMimeTypes(), (Object[])this.getVideoMimeTypes()));
        } else if (mediaType instanceof MediaType.ImageOnly) {
            intent = MediaPickerButtonKt.isPhotoPickerAvailable() ? this.getPhotoPickerIntent(this.getImageMimeTypes()) : this.getNativePickerIntent(this.getImageMimeTypes());
        } else if (mediaType instanceof MediaType.VideOnly) {
            intent = MediaPickerButtonKt.isPhotoPickerAvailable() ? this.getPhotoPickerIntent(this.getVideoMimeTypes()) : this.getNativePickerIntent(this.getVideoMimeTypes());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return intent;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getVideoMimeTypes() {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = this.getAllMimeTypes();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"video", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getImageMimeTypes() {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = this.getAllMimeTypes();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"image", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getDocumentMimeTypes() {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = this.getAllMimeTypes();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"application", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getAllMimeTypes() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.mediaType.getSupportedExtensions();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((Intrinsics.areEqual((Object)it, (Object)"txt") ? null : (MediaPickerButtonKt.access$getDefaultSupportedImageExtensions$p().contains(it) ? "image/" + it : (MediaPickerButtonKt.access$getDefaultSupportedVideoExtensions$p().contains(it) ? "video/" + it : (MediaPickerButtonKt.access$getDefaultSupportedDocumentExtensions$p().contains(it) ? "application/" + it : MimeTypeMap.getSingleton().getMimeTypeFromExtension(it))))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final Intent getPhotoPickerIntent(String[] supportedTypes) {
        Intent intent;
        Intent $this$getPhotoPickerIntent_u24lambda_u246 = intent = new Intent("android.provider.action.PICK_IMAGES");
        boolean bl = false;
        $this$getPhotoPickerIntent_u24lambda_u246.putExtra("android.intent.extra.MIME_TYPES", supportedTypes);
        if (this.maxSelectionCount > 1) {
            if (!(this.maxSelectionCount <= MediaStore.getPickImagesMaxLimit())) {
                boolean bl2 = false;
                String string = "Max items must be less or equals MediaStore.getPickImagesMaxLimit()";
                throw new IllegalArgumentException(string.toString());
            }
            $this$getPhotoPickerIntent_u24lambda_u246.putExtra("android.provider.extra.PICK_IMAGES_MAX", this.maxSelectionCount);
        }
        return intent;
    }

    private final Intent getNativePickerIntent(String[] supportedTypes) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT").addCategory("android.intent.category.OPENABLE").setType((String)ArraysKt.first((Object[])supportedTypes)).putExtra("android.intent.extra.MIME_TYPES", supportedTypes).addFlags(1).putExtra("android.intent.extra.ALLOW_MULTIPLE", this.maxSelectionCount > 1);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(Intent.ACTION_GET\u2026E, maxSelectionCount > 1)");
        return intent;
    }

    private final List<Uri> getClipDataUris(Intent $this$getClipDataUris) {
        LinkedHashSet<Uri> resultSet = new LinkedHashSet<Uri>();
        Uri uri = $this$getClipDataUris.getData();
        if (uri != null) {
            Uri data = uri;
            boolean bl = false;
            resultSet.add(data);
        }
        ClipData clipData = $this$getClipDataUris.getClipData();
        if (clipData == null && resultSet.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (clipData != null) {
            int n = clipData.getItemCount();
            for (int i = 0; i < n; ++i) {
                Uri uri2 = clipData.getItemAt(i).getUri();
                if (uri2 == null) continue;
                resultSet.add(uri2);
            }
        }
        return new ArrayList(resultSet);
    }
}

