/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.gcm;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.gcm.R;
import io.intercom.android.sdk.utilities.Phrase;

class PushNotification {
    private static final String PUSH_ONLY = "push_only";
    private final String conversationId;
    private final String message;
    private final String body;
    private final String authorName;
    private final String imageUrl;
    private final String avatarColor;
    private final String conversationPartType;
    private final String appName;
    private final String receiver;
    private final String intercomPushType;
    private final String uri;
    private final String pushOnlyConversationId;
    private final String title;
    private final int priority;

    @SuppressLint(value={"NewApi"})
    PushNotification(Bundle extras) {
        this.conversationId = extras.getString("conversation_id", "");
        this.message = extras.getString("message", "");
        this.body = extras.getString("body", "");
        this.authorName = extras.getString("author_name", "");
        this.avatarColor = extras.getString("avatar_color", "");
        this.imageUrl = extras.getString("image_url", "");
        this.conversationPartType = extras.getString("conversation_part_type", "");
        this.appName = extras.getString("app_name", "");
        this.receiver = extras.getString("receiver", "");
        this.intercomPushType = extras.getString("intercom_push_type", "");
        this.uri = extras.getString("uri", "");
        this.pushOnlyConversationId = extras.getString("push_only_conv_id", "");
        this.title = extras.getString("title", "");
        this.priority = extras.getInt("intercom_priority_type", 1);
    }

    String getConversationId() {
        return this.conversationId;
    }

    String getMessage() {
        return !this.message.isEmpty() ? this.message : this.body;
    }

    String getColor() {
        return this.avatarColor;
    }

    String getType() {
        return this.conversationPartType;
    }

    String getName() {
        return this.authorName;
    }

    @SuppressLint(value={"PrivateResource"})
    CharSequence getTitle(Context context) {
        if (!this.title.isEmpty()) {
            return this.title;
        }
        if (!this.authorName.isEmpty() && !this.appName.isEmpty()) {
            return Phrase.from((Context)context, (int)R.string.intercom_teammate_from_company).put("name", (CharSequence)this.authorName).put("company", (CharSequence)this.appName).format();
        }
        if (!this.authorName.isEmpty()) {
            return this.authorName;
        }
        return this.appName;
    }

    String getImageUrl() {
        return this.imageUrl;
    }

    String getUri() {
        return this.uri;
    }

    String getPushOnlyConversationId() {
        return this.pushOnlyConversationId;
    }

    boolean isIntercomPush() {
        return !this.intercomPushType.isEmpty() && "intercom_sdk".equals(this.receiver);
    }

    boolean isPushOnly() {
        return PUSH_ONLY.equals(this.intercomPushType);
    }

    int getPriority() {
        return this.priority;
    }
}

