/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.AppTypeDetector;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.ops.OpsMetricObject;
import io.intercom.android.sdk.persistence.JsonStorage;
import io.intercom.android.sdk.utilities.IoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class MetricsStore {
    private static final String METRICS_DIR = "intercomMetrics";
    private static final String OPS_METRICS_DIR = "intercomOpsMetrics";
    private static final int STORED_METRIC_LIMIT = 200;
    private static final int STORED_OP_METRIC_LIMIT = 100;
    private final Provider<Api> apiProvider;
    private final String installerPackageName;
    private final boolean isDebugBuild;
    private final Provider<AppConfig> appConfigProvider;
    private final Executor executor;
    private final JsonStorage storage;
    private final File metricsDir;
    private final File opsMetricsDir;
    private final Twig twig;
    private final JsonStorage.LoadFailureHandler deleteOnFailureHandler = new JsonStorage.LoadFailureHandler(){

        @Override
        public void onLoadFailed(File file, Exception e) {
            IoUtils.safelyDelete(file);
            MetricsStore.this.twig.v((Throwable)e, "Couldn't load file " + file.getAbsolutePath(), new Object[0]);
        }
    };

    public MetricsStore(Context context, Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider) {
        this(apiProvider, appConfigProvider, Executors.newSingleThreadExecutor(), new JsonStorage(new Gson()), new File(context.getCacheDir(), METRICS_DIR), new File(context.getCacheDir(), OPS_METRICS_DIR), AppTypeDetector.isDebugBuild(context), AppTypeDetector.getInstallerPackageName(context), LumberMill.getLogger());
    }

    @VisibleForTesting
    MetricsStore(Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider, Executor executor, JsonStorage storage, File metricsDir, File opsMetricsDir, boolean isDebugBuild, String installerPackageName, Twig twig) {
        this.apiProvider = apiProvider;
        this.appConfigProvider = appConfigProvider;
        this.executor = executor;
        this.storage = storage;
        this.metricsDir = metricsDir;
        this.opsMetricsDir = opsMetricsDir;
        this.isDebugBuild = isDebugBuild;
        this.installerPackageName = installerPackageName;
        this.twig = twig;
    }

    public void track(final MetricObject metric) {
        if (this.isDisabled()) {
            return;
        }
        metric.addInstallerPackageName(this.installerPackageName).addIsDebugBuild(this.isDebugBuild);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (MetricsStore.this.hasReachedMetricStorageLimit()) {
                    return;
                }
                MetricsStore.this.storage.saveToFileAsJson(metric, MetricsStore.this.getFile(metric));
            }
        });
    }

    public void track(final OpsMetricObject opsMetric) {
        if (this.isDisabled()) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (MetricsStore.this.hasReachedOpsMetricStorageLimit()) {
                    return;
                }
                MetricsStore.this.storage.saveToFileAsJson(opsMetric, MetricsStore.this.getFile(opsMetric));
            }
        });
    }

    private boolean isDisabled() {
        return !this.appConfigProvider.get().isMetricsEnabled();
    }

    private boolean hasReachedMetricStorageLimit() {
        return this.storage.getDirectoryFileCount(this.metricsDir) > 200;
    }

    private boolean hasReachedOpsMetricStorageLimit() {
        return this.storage.getDirectoryFileCount(this.opsMetricsDir) > 100;
    }

    private File getFile(MetricObject fullMetric) {
        return new File(this.metricsDir, fullMetric.getId() + ".json");
    }

    private File getFile(OpsMetricObject opsMetric) {
        return new File(this.opsMetricsDir, opsMetric.getId() + ".json");
    }

    public void loadAndSendMetrics() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List<MetricObject> metrics = MetricsStore.this.loadMetrics();
                List<OpsMetricObject> opsMetrics = MetricsStore.this.loadOpsMetrics();
                if (metrics.isEmpty() && opsMetrics.isEmpty()) {
                    return;
                }
                MetricsStore.this.uploadMetrics(metrics, opsMetrics);
            }
        });
    }

    private void uploadMetrics(final List<MetricObject> metrics, final List<OpsMetricObject> opsMetrics) {
        this.apiProvider.get().sendMetrics(metrics, opsMetrics, new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                if (response.isSuccessful() || response.code() == 400) {
                    MetricsStore.this.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            MetricsStore.this.deleteFilesFor(metrics, opsMetrics);
                        }
                    });
                }
            }

            public void onFailure(Call<Void> call, Throwable t) {
            }
        });
    }

    @VisibleForTesting
    List<MetricObject> loadMetrics() {
        final ArrayList<MetricObject> metrics = new ArrayList<MetricObject>();
        this.storage.loadFilesInDirectory(this.metricsDir, MetricObject.class, new JsonStorage.LoadHandler<List<MetricObject>>(){

            @Override
            public void onLoad(List<MetricObject> loadedMetrics) {
                MetricsStore.copyNonNullItems(loadedMetrics, metrics);
            }
        }, this.deleteOnFailureHandler);
        return metrics;
    }

    @VisibleForTesting
    List<OpsMetricObject> loadOpsMetrics() {
        final ArrayList<OpsMetricObject> opsMetrics = new ArrayList<OpsMetricObject>();
        this.storage.loadFilesInDirectory(this.opsMetricsDir, OpsMetricObject.class, new JsonStorage.LoadHandler<List<OpsMetricObject>>(){

            @Override
            public void onLoad(List<OpsMetricObject> loadedOpsMetrics) {
                MetricsStore.copyNonNullItems(loadedOpsMetrics, opsMetrics);
            }
        }, this.deleteOnFailureHandler);
        return opsMetrics;
    }

    private static <T> void copyNonNullItems(List<T> list, List<T> newList) {
        for (T item : list) {
            if (item == null) continue;
            newList.add(item);
        }
    }

    @VisibleForTesting
    void deleteFilesFor(List<MetricObject> metrics, List<OpsMetricObject> opsMetrics) {
        for (MetricObject metric : metrics) {
            IoUtils.safelyDelete(this.getFile(metric));
        }
        for (OpsMetricObject opsMetric : opsMetrics) {
            IoUtils.safelyDelete(this.getFile(opsMetric));
        }
    }
}

