/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.RequestManager;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.homescreen.BaseConversationCardViewHolder;
import io.intercom.android.sdk.homescreen.ConversationCard;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.views.OfficeHoursTextView;
import java.util.List;

public class NewConversationCardViewHolder
extends BaseConversationCardViewHolder {
    private final FrameLayout avatarLayout;
    private final OfficeHoursTextView officeHoursView;
    private final TextView seePreviousButton;
    private final View divider;
    @VisibleForTesting
    final TextView newConversationButton;
    private final Context context;
    private final Resources resources;
    private final TextView conversationCardTitle;
    @Px
    private int homeScreenWidth;

    NewConversationCardViewHolder(View itemView, Provider<AppConfig> appConfigProvider, HomeClickListener clickListener) {
        super(itemView, appConfigProvider, clickListener);
        this.newConversationButton = (TextView)itemView.findViewById(R.id.new_conversation_button);
        this.avatarLayout = (FrameLayout)itemView.findViewById(R.id.avatar_layout);
        LinearLayout rootLayout = (LinearLayout)itemView.findViewById(R.id.new_conversation_card_layout);
        this.officeHoursView = (OfficeHoursTextView)itemView.findViewById(R.id.office_hours);
        this.divider = itemView.findViewById(R.id.divider);
        this.seePreviousButton = (TextView)itemView.findViewById(R.id.see_previous);
        this.conversationCardTitle = (TextView)itemView.findViewById(R.id.intercom_conversation_card_title);
        this.context = rootLayout.getContext();
        this.resources = this.context.getResources();
        this.homeScreenWidth = this.getHomeScreenWidth();
        this.newConversationButton.setOnClickListener(this.onNewConversationClicked);
        this.seePreviousButton.setOnClickListener(this.onSeePreviousClicked);
        this.applyCardBorderStyle((View)rootLayout);
        this.applyNewConversationButtonStyle(this.newConversationButton);
        this.applyAllConversationButtonStyle(this.seePreviousButton);
        this.showOrHideNewConversationButton(this.newConversationButton);
    }

    private void applyNewConversationButtonStyle(TextView newConversationButton) {
        FontUtils.setRobotoMediumTypeface(newConversationButton);
        this.updateButtonBackgroundColor(newConversationButton, ((AppConfig)this.appConfigProvider.get()).getPrimaryColor());
        boolean shouldRenderDarkText = ((AppConfig)this.appConfigProvider.get()).primaryColorRenderDarkText();
        int buttonTextColor = ColorUtils.whiteOrDarkColor(this.context, shouldRenderDarkText);
        newConversationButton.setTextColor(buttonTextColor);
        ColorUtils.updateLeftDrawableColor(newConversationButton, buttonTextColor);
    }

    public void bindTeamPresence(TeamPresence teamPresence, RequestManager requestManager, ConversationCard conversationCard) {
        if (!conversationCard.isTeammateEnabled()) {
            this.avatarLayout.setVisibility(8);
            this.conversationCardTitle.setText(R.string.intercom_how_can_we_help);
            this.officeHoursView.setVisibility(0);
            this.officeHoursView.setText(R.string.intercom_tell_us_what_you_need);
            this.newConversationButton.setText(R.string.intercom_ask_a_question);
            this.newConversationButton.setCompoundDrawablesWithIntrinsicBounds(R.drawable.intercom_conversation_card_question, 0, 0, 0);
            int seePreviousVisibility = conversationCard.hasOlderConversations() ? 0 : 8;
            this.seePreviousButton.setVisibility(seePreviousVisibility);
            this.divider.setVisibility(seePreviousVisibility);
            this.updateOlderConversationUnreadState(this.seePreviousButton, conversationCard.hasOlderUnreadConversations());
        } else if (teamPresence.isEmpty()) {
            this.officeHoursView.setVisibility(8);
            this.avatarLayout.setVisibility(8);
            this.seePreviousButton.setVisibility(8);
            this.divider.setVisibility(8);
        } else {
            int seePreviousVisibility = conversationCard.hasOlderConversations() ? 0 : 8;
            this.seePreviousButton.setVisibility(seePreviousVisibility);
            this.divider.setVisibility(seePreviousVisibility);
            this.officeHoursView.setVisibility(0);
            this.avatarLayout.setVisibility(0);
            List<Participant> teammates = teamPresence.getActiveAdmins();
            if (!teammates.isEmpty()) {
                this.displayAvatars(teammates, requestManager);
            }
            this.updateOfficeHours(this.officeHoursView, teamPresence);
            this.updateOlderConversationUnreadState(this.seePreviousButton, conversationCard.hasOlderUnreadConversations());
        }
    }

    private void displayAvatars(List<Participant> teammates, RequestManager requestManager) {
        View view;
        ImageView avatarView;
        boolean shouldAddAvatar;
        int cardPadding = this.resources.getDimensionPixelOffset(R.dimen.intercom_conversation_card_padding);
        int cardMargin = this.resources.getDimensionPixelOffset(R.dimen.intercom_home_card_margin);
        int maxWidth = this.homeScreenWidth - 2 * cardPadding - 2 * cardMargin;
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        for (int index = 0; index < teammates.size() && (shouldAddAvatar = this.updateLeftMarginForIndex(avatarView = (ImageView)(view = inflater.inflate(R.layout.intercom_view_conversation_card_avatar, (ViewGroup)this.avatarLayout, false)).findViewById(R.id.avatar_view), index, maxWidth)); ++index) {
            AvatarUtils.loadAvatarIntoView(teammates.get(index).getAvatar(), avatarView, (AppConfig)this.appConfigProvider.get(), requestManager);
            this.avatarLayout.addView((View)avatarView);
        }
    }

    private boolean updateLeftMarginForIndex(ImageView imageView, int index, @Px int maxWidth) {
        int avatarSize;
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)imageView.getLayoutParams();
        Resources resources = imageView.getContext().getResources();
        int marginPx = resources.getDimensionPixelSize(R.dimen.intercom_conversation_card_avatar_margin);
        int expectedLeftMargin = index * marginPx;
        if (expectedLeftMargin + (avatarSize = resources.getDimensionPixelSize(R.dimen.intercom_conversation_card_avatar_size)) <= maxWidth) {
            params.leftMargin = index * marginPx;
            imageView.setLayoutParams((ViewGroup.LayoutParams)params);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void updateOfficeHours(OfficeHoursTextView textView, TeamPresence teamPresence) {
        String officeHours = teamPresence.getOfficeHours();
        if (TextUtils.isEmpty((CharSequence)officeHours)) {
            textView.setText(teamPresence.getExpectedResponseDelay());
        } else {
            textView.setText(officeHours);
            int imageColor = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_conversation_card_summary_text);
            textView.setOfficeHoursDrawable(imageColor);
        }
    }

    private int getHomeScreenWidth() {
        return this.resources.getDisplayMetrics().widthPixels;
    }
}

