/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityOptionsCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.RequestManager;
import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomArticleActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.conversation.SuggestionsClickListener;
import io.intercom.android.sdk.conversation.attribute.AttributeInputListener;
import io.intercom.android.sdk.conversation.attribute.OnDateAttributeSetListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.LinkOpener;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.ListAttributeSelectorDialogBuilder;
import io.intercom.android.sdk.views.PartMetadataFormatter;
import io.intercom.android.sdk.views.holder.AttributeCollectorViewHolder;
import io.intercom.android.sdk.views.holder.ComposerSuggestionsViewHolder;
import io.intercom.android.sdk.views.holder.ContainerCardViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationLoadingViewHolder;
import io.intercom.android.sdk.views.holder.ConversationPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationRatingViewHolder;
import io.intercom.android.sdk.views.holder.EventViewHolder;
import io.intercom.android.sdk.views.holder.LinkListViewHolder;
import io.intercom.android.sdk.views.holder.LinkViewHolder;
import io.intercom.android.sdk.views.holder.PartViewHolder;
import io.intercom.android.sdk.views.holder.QuickReplyClickListener;
import io.intercom.android.sdk.views.holder.QuickReplyViewHolder;
import io.intercom.android.sdk.views.holder.TemporaryExpectationsViewHolder;
import io.intercom.android.sdk.views.holder.TimeStampViewHolder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class ConversationPartAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ConversationListener {
    private final PartMetadataFormatter partMetadataFormatter;
    private final List<Part> partList;
    private final ClipboardManager clipboardManager;
    private final Listener listener;
    private final TimeFormatter timeFormatter;
    private final Map<Part, ViewGroup> partViewMap;
    private final Api api;
    private final Activity rootActivity;
    private final Provider<AppConfig> appConfigProvider;
    private final UserIdentity userIdentity;
    private final RequestManager requestManager;
    private final MetricTracker metricTracker;
    private final Locale locale;
    private String conversationId;
    private boolean allowExpansionArrow = false;
    @Nullable
    private Part selectedPart;
    @Nullable
    private QuickReplyClickListener quickReplyClickListener;
    @Nullable
    private SuggestionsClickListener suggestionsClickListener;

    public static ConversationPartAdapter create(Activity rootActivity, List<Part> partList, Listener listener, Api api, String conversationId, Provider<AppConfig> appConfigProvider, UserIdentity userIdentity, TimeProvider timeProvider, ContextLocaliser contextLocaliser, RequestManager requestManager, MetricTracker metricTracker, Locale locale) {
        ClipboardManager clipboardManager = (ClipboardManager)rootActivity.getSystemService("clipboard");
        Context localisedContext = contextLocaliser.createLocalisedContext((Context)rootActivity);
        TimeFormatter timeFormatter = new TimeFormatter(localisedContext, timeProvider);
        PartMetadataFormatter partMetadataFormatter = new PartMetadataFormatter(timeFormatter);
        return new ConversationPartAdapter(partList, clipboardManager, listener, partMetadataFormatter, timeFormatter, new HashMap<Part, ViewGroup>(), api, rootActivity, conversationId, appConfigProvider, userIdentity, requestManager, metricTracker, locale);
    }

    ConversationPartAdapter(List<Part> partList, ClipboardManager clipboardManager, Listener listener, PartMetadataFormatter partMetadataFormatter, TimeFormatter timeFormatter, Map<Part, ViewGroup> blockViewMap, Api api, Activity rootActivity, String conversationId, Provider<AppConfig> appConfigProvider, UserIdentity userIdentity, RequestManager requestManager, MetricTracker metricTracker, Locale locale) {
        this.partList = partList;
        this.clipboardManager = clipboardManager;
        this.listener = listener;
        this.partMetadataFormatter = partMetadataFormatter;
        this.timeFormatter = timeFormatter;
        this.partViewMap = blockViewMap;
        this.api = api;
        this.rootActivity = rootActivity;
        this.conversationId = conversationId;
        this.appConfigProvider = appConfigProvider;
        this.userIdentity = userIdentity;
        this.requestManager = requestManager;
        this.metricTracker = metricTracker;
        this.locale = locale;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 6: {
                return new TimeStampViewHolder(inflater.inflate(R.layout.intercom_day_divider, parent, false), this.timeFormatter);
            }
            case 1: 
            case 4: 
            case 5: {
                return new PartViewHolder(inflater.inflate(R.layout.intercom_row_admin_part, parent, false), viewType, this, this.clipboardManager, this.partMetadataFormatter, this.appConfigProvider, this.requestManager, this.metricTracker);
            }
            case 15: {
                View formView = inflater.inflate(R.layout.intercom_row_attribute_collector_part, parent, false);
                return new AttributeCollectorViewHolder(formView, this.appConfigProvider, this, this.requestManager, this.locale);
            }
            case 2: {
                return new ContainerCardViewHolder(inflater.inflate(R.layout.intercom_row_post, parent, false), viewType, this, this.clipboardManager, false, this.appConfigProvider, this.requestManager);
            }
            case 3: {
                return new ContainerCardViewHolder(inflater.inflate(R.layout.intercom_row_note, parent, false), viewType, this, this.clipboardManager, this.allowExpansionArrow, this.appConfigProvider, this.requestManager);
            }
            case 7: {
                View view = inflater.inflate(R.layout.intercom_row_loading, parent, false);
                return new ConversationLoadingViewHolder(view);
            }
            case 8: {
                return new LinkViewHolder(inflater.inflate(R.layout.intercom_row_link, parent, false), viewType, this, this.clipboardManager, this.appConfigProvider, this.requestManager);
            }
            case 9: {
                return new LinkViewHolder(inflater.inflate(R.layout.intercom_row_link_reply, parent, false), viewType, this, this.clipboardManager, this.appConfigProvider, this.requestManager);
            }
            case 10: {
                return new ConversationRatingViewHolder(inflater.inflate(R.layout.intercom_row_conversation_rating, parent, false), this, this.appConfigProvider, this.requestManager);
            }
            case 13: {
                return new LinkListViewHolder(inflater.inflate(R.layout.intercom_row_link_list, parent, false), this, this.appConfigProvider, this.requestManager);
            }
            case 12: {
                return new EventViewHolder(inflater.inflate(R.layout.intercom_row_event, parent, false), this.appConfigProvider, this.requestManager);
            }
            case 14: {
                return new QuickReplyViewHolder(inflater.inflate(R.layout.intercom_row_quick_reply_part, parent, false), viewType, this, this.clipboardManager, this.partMetadataFormatter, this.appConfigProvider, this.requestManager, this.metricTracker);
            }
            case 16: {
                return new ComposerSuggestionsViewHolder(inflater.inflate(R.layout.intercom_row_composer_suggestions_part, parent, false), viewType, this, this.clipboardManager, this.partMetadataFormatter, this.appConfigProvider, this.requestManager, this.metricTracker);
            }
            case 17: {
                return new TemporaryExpectationsViewHolder(inflater.inflate(R.layout.intercom_row_temporary_expectations, parent, false));
            }
        }
        return new PartViewHolder(inflater.inflate(R.layout.intercom_row_user_part, parent, false), viewType, this, this.clipboardManager, this.partMetadataFormatter, this.appConfigProvider, this.requestManager, this.metricTracker);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ConversationPartViewHolder) {
            Part part = this.getPart(position);
            ViewGroup blocksLayout = this.partViewMap.get(part);
            if (blocksLayout == null) {
                blocksLayout = new FrameLayout(holder.itemView.getContext());
            }
            ((ConversationPartViewHolder)holder).bind(part, blocksLayout);
        }
    }

    public int getItemViewType(int position) {
        Part part = this.partList.get(position);
        String messageStyle = part.getMessageStyle();
        if (part.isEvent().booleanValue()) {
            return 12;
        }
        if ("admin_is_typing_style".equals(messageStyle)) {
            return 5;
        }
        if ("day_divider_style".equals(messageStyle)) {
            return 6;
        }
        if ("loading_layout_style".equals(messageStyle)) {
            return 7;
        }
        if ("composer_suggestions_style".equals(messageStyle)) {
            return 16;
        }
        if ("temporary_expectations_style".equals(messageStyle)) {
            return 17;
        }
        Participant author = part.getParticipant();
        if (author.isAdmin()) {
            if (part.isLinkCard()) {
                return part.isInitialMessage() ? 8 : 9;
            }
            if (part.isSingleBlockPartOfType(BlockType.CONVERSATIONRATING)) {
                return 10;
            }
            if (part.isSingleBlockPartOfType(BlockType.LINKLIST)) {
                return 13;
            }
            if ("post".equals(messageStyle)) {
                return 2;
            }
            if ("note".equals(messageStyle)) {
                this.startAllowingExpansionArrowIfPositionIsNotLast(position);
                return 3;
            }
            if ("attribute_collector".equals(messageStyle)) {
                return 15;
            }
            if ("quick_reply".equals(messageStyle)) {
                return 14;
            }
            return 1;
        }
        if (author.isUserWithId(this.userIdentity.getIntercomId())) {
            return 0;
        }
        return 4;
    }

    private void startAllowingExpansionArrowIfPositionIsNotLast(int position) {
        this.allowExpansionArrow |= position != this.partList.size() - 1;
    }

    public int getItemCount() {
        return this.partList.size();
    }

    @Override
    public int getCount() {
        return this.getItemCount();
    }

    @Override
    public Part getPart(int position) {
        return this.partList.get(position);
    }

    @Override
    @Nullable
    public Part getSelectedPart() {
        return this.selectedPart;
    }

    @Override
    public void onPartClicked(int position, PartViewHolder partViewHolder) {
        Part part = this.partList.get(position);
        if (part.getMessageState() == Part.MessageState.FAILED || part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            this.listener.onPartClicked(part);
        } else if (position < this.getCount() - 1) {
            if (part == this.selectedPart) {
                this.selectedPart = null;
                partViewHolder.setExpanded(false);
            } else {
                int index = this.partList.indexOf(this.selectedPart);
                this.notifyItemChanged(index);
                this.selectedPart = part;
                partViewHolder.setExpanded(true);
            }
        }
    }

    @Override
    public void onContainerCardClicked(int position, ContainerCardViewHolder containerCardViewHolder) {
        Part part = this.partList.get(position);
        switch (this.getItemViewType(position)) {
            case 3: {
                if (!this.allowExpansionArrow) break;
                containerCardViewHolder.toggleExpanded();
                break;
            }
            case 2: {
                this.listener.onPostCardClicked(part);
                break;
            }
        }
    }

    @Override
    public void onLinkClicked(int position, View background) {
        Part part = this.partList.get(position);
        Block linkBlock = part.getLinkBlock();
        if ("educate.article".equals(linkBlock.getLinkType())) {
            this.openArticleActivity(linkBlock, part, background);
        } else {
            LinkOpener.handleUrl(linkBlock.getUrl(), (Context)this.rootActivity, this.api);
        }
    }

    @Override
    public void onSubmitAttribute(String partId, String identifier, Object value, String formType) {
        this.api.submitForm(this.conversationId, partId, identifier, value, formType);
    }

    @Override
    public void onQuickReplyClicked(Participant author, Part part, ReplyOption option) {
        if (this.quickReplyClickListener == null) {
            return;
        }
        this.quickReplyClickListener.onQuickReplyClicked(author, part, option);
    }

    @Override
    public void onComposerSuggestionClicked(Part part, Suggestion suggestion) {
        if (this.suggestionsClickListener == null) {
            return;
        }
        this.suggestionsClickListener.onSuggestionClicked(part, suggestion);
    }

    @Override
    public void onListAttributeClicked(String partId, Attribute attribute, AttributeInputListener listener) {
        new ListAttributeSelectorDialogBuilder((Context)this.rootActivity, partId, attribute, this, listener).show();
    }

    @Override
    public void onDateAttributeClicked(String partId, String identifier, String formType, AttributeInputListener listener) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        DatePickerDialog dialog = new DatePickerDialog((Context)this.rootActivity, R.style.Intercom_DatePicker, (DatePickerDialog.OnDateSetListener)new OnDateAttributeSetListener(partId, identifier, formType, this, listener), year, month, day);
        dialog.show();
        int primaryColor = this.appConfigProvider.get().getPrimaryColor();
        Button positiveButton = dialog.getButton(-1);
        positiveButton.setText(17039370);
        positiveButton.setTextColor(primaryColor);
        dialog.getButton(-2).setTextColor(primaryColor);
    }

    @Override
    public String getConversationId() {
        return this.conversationId;
    }

    @Override
    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    private void openArticleActivity(Block linkBlock, Part part, View background) {
        Intent intent = IntercomArticleActivity.buildIntent((Context)this.rootActivity, linkBlock.getArticleId(), part.getId(), this.conversationId);
        ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)this.rootActivity, (View)background, (String)"link_background");
        this.rootActivity.startActivity(intent, options.toBundle());
    }

    public void setQuickReplyClickListener(@Nullable QuickReplyClickListener quickReplyClickListener) {
        this.quickReplyClickListener = quickReplyClickListener;
    }

    public void setSuggesstionsClickListener(@Nullable SuggestionsClickListener suggestionsClickListener) {
        this.suggestionsClickListener = suggestionsClickListener;
    }

    void setViewForPart(Part part, ViewGroup view) {
        this.partViewMap.put(part, view);
    }

    void removeViewForPart(Part part) {
        this.partViewMap.remove(part);
    }

    @Nullable
    ViewGroup getViewForPart(Part part) {
        return this.partViewMap.get(part);
    }

    static interface Listener {
        public void onPartClicked(Part var1);

        public void onPostCardClicked(Part var1);
    }
}

