/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.carousel;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.ContentLayoutManager;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.carousel.ActionOnClickListener;
import io.intercom.android.sdk.carousel.CarouselListener;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.carousel.CarouselScreen;
import io.intercom.android.sdk.models.carousel.ScreenAction;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.views.ContentAwareScrollView;
import java.util.List;

public class CarouselScreenFragment
extends Fragment {
    public static final int CAROUSEL_ANIMATION_MS = 400;
    public static final int CAROUSEL_ANIMATION_DELAY_MS = 300;
    private static final String KEY_CAROUSEL_SCREEN = "carousel_screen";
    private boolean tickShouldAnimate = true;
    private LinearLayout actionLayout;
    private CarouselScreen carouselScreen = CarouselScreen.NULL;
    private CarouselListener listener;
    private PermissionManager permissionManager;
    private Bus bus;

    public static CarouselScreenFragment newInstance(CarouselScreen screen) {
        CarouselScreenFragment fragment = new CarouselScreenFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_CAROUSEL_SCREEN, (Parcelable)screen);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (CarouselListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement CarouselListener");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.carouselScreen = (CarouselScreen)bundle.getParcelable(KEY_CAROUSEL_SCREEN);
        }
        Injector injector = Injector.get();
        Provider<AppConfig> appConfigProvider = injector.getAppConfigProvider();
        this.bus = injector.getBus();
        ViewHolderGenerator generator = new ViewHolderGenerator(new UploadingImageCache(), injector.getApi(), appConfigProvider, "", null, null, Glide.with((Fragment)this), injector.getGson(), injector.getBus(), injector.getMetricTracker(), (Activity)this.getActivity());
        ContentLayoutManager contentLayoutManager = new ContentLayoutManager(this.getContext(), generator.getCarouselHolder());
        this.permissionManager = new PermissionManager((Activity)this.getActivity());
        View view = inflater.inflate(R.layout.intercom_fragment_carousel_screen, container, false);
        LinearLayout rootLayout = (LinearLayout)view.findViewById(R.id.intercom_carousel_fragment_root);
        this.actionLayout = (LinearLayout)view.findViewById(R.id.intercom_carousel_action_layout);
        FrameLayout contentContainer = (FrameLayout)view.findViewById(R.id.intercom_carousel_content_container);
        View gradientView = view.findViewById(R.id.intercom_carousel_gradient);
        ContentAwareScrollView contentAwareScrollView = (ContentAwareScrollView)view.findViewById(R.id.intercom_carousel_scroll_view);
        int backgroundColor = Color.parseColor((String)this.carouselScreen.getBackgroundColor());
        this.applyBottomGradient(gradientView, contentAwareScrollView, backgroundColor);
        rootLayout.setBackgroundColor(backgroundColor);
        this.displayScreenActions();
        contentLayoutManager.renderCarouselScreen(this.carouselScreen, contentContainer);
        return view;
    }

    public void onStart() {
        super.onStart();
        this.bus.register((Object)this);
    }

    public void onStop() {
        this.bus.unregister((Object)this);
        super.onStop();
    }

    public void onResume() {
        super.onResume();
        this.displayScreenActions();
    }

    private void displayScreenActions() {
        this.actionLayout.removeAllViews();
        List<ScreenAction> actions = this.carouselScreen.getActions();
        ScreenAction permissionAction = this.carouselScreen.getPermissionAction();
        for (ScreenAction action : actions) {
            TextView actionButtonView = this.createButton(action);
            if (!ScreenAction.NULL.equals(permissionAction) && this.permissionManager.permissionsGranted(permissionAction.getValidPermissions(this.permissionManager))) {
                if ("skip".equals(action.getType())) {
                    this.actionLayout.addView((View)this.buttonWithTickIcon(actionButtonView, Color.parseColor((String)action.getTextColor())));
                    continue;
                }
                if (!action.isPermissionAction()) continue;
                continue;
            }
            this.actionLayout.addView((View)actionButtonView);
        }
    }

    private TextView createButton(ScreenAction screenAction) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        TextView actionButton = (TextView)layoutInflater.inflate(R.layout.intercom_carousel_action_button, (ViewGroup)this.actionLayout, false);
        FontUtils.setRobotoMediumTypeface(actionButton);
        actionButton.setText((CharSequence)screenAction.getTitle());
        actionButton.getBackground().setColorFilter(Color.parseColor((String)screenAction.getBackgroundColor()), PorterDuff.Mode.SRC_IN);
        actionButton.setTextColor(Color.parseColor((String)screenAction.getTextColor()));
        actionButton.setOnClickListener((View.OnClickListener)new ActionOnClickListener(screenAction, this.listener));
        return actionButton;
    }

    private FrameLayout buttonWithTickIcon(TextView actionButton, @ColorInt int iconColor) {
        actionButton.setText((CharSequence)"");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        FrameLayout frameLayout = new FrameLayout(actionButton.getContext());
        frameLayout.setLayoutParams(actionButton.getLayoutParams());
        ImageView tickIcon = (ImageView)layoutInflater.inflate(R.layout.intercom_carousel_action_button_tick, (ViewGroup)frameLayout, false);
        tickIcon.getDrawable().setColorFilter(iconColor, PorterDuff.Mode.SRC_IN);
        frameLayout.addView((View)actionButton);
        frameLayout.addView((View)tickIcon);
        if (this.tickShouldAnimate) {
            this.animateTickIcon(tickIcon);
        }
        return frameLayout;
    }

    private void animateTickIcon(ImageView tickIcon) {
        tickIcon.clearAnimation();
        tickIcon.setAlpha(0.0f);
        tickIcon.setScaleX(0.0f);
        tickIcon.setScaleY(0.0f);
        tickIcon.setRotation(-360.0f);
        tickIcon.animate().alpha(1.0f).rotationBy(360.0f).scaleX(1.0f).scaleY(1.0f).setStartDelay(300L).setDuration(400L).start();
        this.tickShouldAnimate = false;
    }

    private void applyBottomGradient(final View gradientView, final ContentAwareScrollView contentAwareScrollView, @ColorInt int backgroundColor) {
        int endColor = ColorUtils.setAlphaComponent((int)backgroundColor, (int)0);
        int[] colors = new int[]{backgroundColor, endColor};
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, colors);
        gradientView.setBackground((Drawable)gradientDrawable);
        contentAwareScrollView.setListener(new ContentAwareScrollView.Listener(){

            @Override
            public void onBottomReached() {
                gradientView.setVisibility(8);
            }

            @Override
            public void onScrollChanged(int scrollPosition) {
                if (!contentAwareScrollView.isAtBottom()) {
                    gradientView.setVisibility(0);
                }
            }
        });
        gradientView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (contentAwareScrollView.isAtBottom()) {
                    gradientView.setVisibility(8);
                }
            }
        });
    }
}

