/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.RequestManager;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.InboxRowLayout;

class InboxRowViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private final InboxRowLayout inboxRowLayout;
    private final ConversationClickListener conversationClickListener;
    private final TimeFormatter timeFormatter;
    private final RequestManager requestManager;

    InboxRowViewHolder(InboxRowLayout itemView, ConversationClickListener conversationClickListener, TimeFormatter timeFormatter, RequestManager requestManager) {
        super((View)itemView);
        this.conversationClickListener = conversationClickListener;
        this.timeFormatter = timeFormatter;
        this.requestManager = requestManager;
        itemView.setOnClickListener(this);
        this.inboxRowLayout = itemView;
    }

    void bindData(Conversation conversation, UserIdentity userIdentity, AppConfig appConfig, TeamPresence teamPresence) {
        this.inboxRowLayout.updateConversation(conversation, userIdentity, appConfig, teamPresence, this.requestManager, this.timeFormatter);
    }

    public void onClick(View v) {
        int index = this.getAdapterPosition();
        if (index != -1) {
            this.conversationClickListener.onConversationClicked(index);
        }
    }
}

