/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;

class RateLimiter {
    private final AppConfig appConfig;
    private final TimeProvider timeProvider;
    private long periodStartTimestamp;
    private int limitedRequestCount;
    private final Twig twig = LumberMill.getLogger();

    RateLimiter(AppConfig appConfig) {
        this(appConfig, TimeProvider.SYSTEM);
    }

    @VisibleForTesting
    RateLimiter(AppConfig appConfig, TimeProvider timeProvider) {
        this.appConfig = appConfig;
        this.timeProvider = timeProvider;
    }

    void recordRequest() {
        if (!this.isInsideCurrentTimePeriod()) {
            this.periodStartTimestamp = this.timeProvider.currentTimeMillis();
            this.limitedRequestCount = 0;
        }
        ++this.limitedRequestCount;
    }

    void logError() {
        this.twig.e("Your app is being rate limited because you're performing too many requests per minute", new Object[0]);
    }

    boolean isLimited() {
        return this.isInsideCurrentTimePeriod() && this.hasReachedMaxCount();
    }

    private boolean isInsideCurrentTimePeriod() {
        return this.timeProvider.currentTimeMillis() - this.periodStartTimestamp < this.appConfig.getRateLimitPeriodMs();
    }

    private boolean hasReachedMaxCount() {
        return this.limitedRequestCount >= this.appConfig.getRateLimitCount();
    }
}

