/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.GifResponse;
import io.intercom.android.sdk.models.HomeCardsResponse;
import io.intercom.android.sdk.models.LinkResponse;
import io.intercom.android.sdk.models.LogEventResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Sheet;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.http.Body;
import io.intercom.retrofit2.http.POST;
import io.intercom.retrofit2.http.PUT;
import io.intercom.retrofit2.http.Path;
import java.util.Map;

interface MessengerApi {
    @POST(value="conversations")
    public Call<Conversation.Builder> startNewConversation(@Body Map<String, Object> var1);

    @POST(value="conversations/{conversationId}/react")
    public Call<Void> reactToConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/form")
    public Call<Conversation.Builder> submitForm(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/reply")
    public Call<Part.Builder> replyToConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/read")
    public Call<Void> markAsRead(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/dismiss")
    public Call<Void> markAsDismissed(@Body Map<String, Object> var1);

    @POST(value="conversations/{conversationId}/record_interactions")
    public Call<Void> recordInteractions(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/inbox")
    public Call<ConversationsResponse.Builder> getConversations(@Body Map<String, Object> var1);

    @POST(value="conversations/unread")
    public Call<UsersResponse.Builder> getUnreadConversations(@Body Map<String, Object> var1);

    @POST(value="conversations/{conversationId}")
    public Call<Conversation.Builder> getConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/conditions_satisfied")
    public Call<Void> satisfyCondition(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/rate")
    public Call<Void> rateConversation(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/remark")
    public Call<Void> addConversationRatingRemark(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="conversations/{conversationId}/quick_reply")
    public Call<Part.Builder> addConversationQuickReply(@Path(value="conversationId") String var1, @Body Map<String, Object> var2);

    @POST(value="users")
    public Call<UpdateUserResponse.Builder> updateUser(@Body Map<String, Object> var1);

    @POST(value="events")
    public Call<LogEventResponse.Builder> logEvent(@Body Map<String, Object> var1);

    @POST(value="uploads")
    public Call<Upload.Builder> uploadFile(@Body Map<String, Object> var1);

    @POST(value="device_tokens")
    public Call<Void> setDeviceToken(@Body Map<String, Object> var1);

    @PUT(value="device_tokens")
    public Call<Void> deleteDeviceToken(@Body Map<String, Object> var1);

    @POST(value="metrics")
    public Call<Void> sendMetrics(@Body Map<String, Object> var1);

    @POST(value="articles/{articleId}")
    public Call<LinkResponse.Builder> getLink(@Path(value="articleId") String var1, @Body Map<String, Object> var2);

    @POST(value="articles/{articleId}/react")
    public Call<Void> reactToLink(@Path(value="articleId") String var1, @Body Map<String, Object> var2);

    @POST(value="gifs")
    public Call<GifResponse> getGifs(@Body Map<String, Object> var1);

    @POST(value="error_reports")
    public Call<Void> reportError(@Body Map<String, Object> var1);

    @POST(value="sheets/open")
    public Call<Sheet.Builder> getSheet(@Body Map<String, Object> var1);

    @POST(value="sheets/submit")
    public Call<Void> submitSheet(@Body Map<String, Object> var1);

    @POST(value="home_cards")
    public Call<HomeCardsResponse.Builder> getHomeCards(@Body Map<String, Object> var1);

    @POST(value="custom_bots/trigger_inbound_conversation")
    public Call<Conversation.Builder> triggerInboundConversation(@Body Map<String, Object> var1);

    @POST(value="stats_system/push_opened")
    public Call<Void> markPushAsOpened(@Body Map<String, Object> var1);

    @POST(value="stats_system/carousel_dismissed")
    public Call<Void> markCarouselAsDismissed(@Body Map<String, Object> var1);

    @POST(value="stats_system/carousel_completed")
    public Call<Void> markCarouselAsCompleted(@Body Map<String, Object> var1);

    @POST(value="stats_system/carousel_screen_viewed")
    public Call<Void> markCarouselScreenViewed(@Body Map<String, Object> var1);

    @POST(value="stats_system/carousel_permission_granted")
    public Call<Void> markPermissionGranted(@Body Map<String, Object> var1);

    @POST(value="stats_system/carousel_button_action_tapped")
    public Call<Void> markCarouselActionButtonTapped(@Body Map<String, Object> var1);
}

