/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.IntercomPushManager;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.UserAttributes;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomHelpCenterActivity;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.errorreporting.ErrorReporter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.overlay.OverlayPresenter;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.UnreadCountTracker;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.ActivityFinisher;
import io.intercom.android.sdk.utilities.AttributeSanitiser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class RealIntercom
extends Intercom {
    private final DeDuper superDeDuper;
    private final Provider<Api> apiProvider;
    private final NexusClient nexusClient;
    private final Store<State> store;
    private final UnreadCountTracker unreadCountTracker;
    private final MetricTracker metricTracker;
    private final Context context;
    private final OverlayPresenter overlayPresenter;
    private final Provider<AppConfig> appConfigProvider;
    private final UserIdentity userIdentity;
    private final SystemNotificationManager systemNotificationManager;
    private final ResetManager resetManager;
    private final Provider<UserUpdater> userUpdater;
    private final Twig twig;
    private final ActivityFinisher activityFinisher;

    static Intercom create(Application application, String apiKey, String appId) {
        Injector.initWithAppCredentials(application, apiKey, appId);
        Injector injector = Injector.get();
        UserIdentity userIdentity = injector.getUserIdentity();
        Store<State> store = injector.getStore();
        return new RealIntercom(injector.getDeDuper(), injector.getApiProvider(), injector.getNexusClient(), store, new UnreadCountTracker(store), injector.getMetricTracker(), injector.getErrorReporter(), (Context)application, injector.getOverlayPresenter(), injector.getAppConfigProvider(), userIdentity, injector.getSystemNotificationManager(), injector.getUserUpdaterProvider(), injector.getResetManager(), LumberMill.getLogger(), injector.getActivityFinisher());
    }

    @VisibleForTesting
    RealIntercom(DeDuper superDeDuper, Provider<Api> apiProvider, NexusClient nexusClient, Store<State> store, UnreadCountTracker unreadCountTracker, MetricTracker metricTracker, ErrorReporter errorReporter, Context context, OverlayPresenter overlayPresenter, Provider<AppConfig> appConfigProvider, UserIdentity userIdentity, SystemNotificationManager systemNotificationManager, Provider<UserUpdater> userUpdater, ResetManager resetManager, Twig twig, ActivityFinisher activityFinisher) {
        this.superDeDuper = superDeDuper;
        this.apiProvider = apiProvider;
        this.nexusClient = nexusClient;
        this.store = store;
        this.unreadCountTracker = unreadCountTracker;
        this.metricTracker = metricTracker;
        this.context = context;
        this.overlayPresenter = overlayPresenter;
        this.appConfigProvider = appConfigProvider;
        this.userIdentity = userIdentity;
        this.systemNotificationManager = systemNotificationManager;
        this.userUpdater = userUpdater;
        this.resetManager = resetManager;
        this.twig = twig;
        this.activityFinisher = activityFinisher;
        switch (IntercomPushManager.getInstalledModuleType()) {
            case FCM: {
                twig.i("Enabling FCM for cloud messaging", new Object[0]);
                systemNotificationManager.setUpNotificationChannelsIfSupported(context);
                break;
            }
            default: {
                systemNotificationManager.deleteNotificationChannels();
                twig.internal("No FCM integration detected");
            }
        }
        if (this.shouldDisableErrorReporting()) {
            errorReporter.disableExceptionHandler();
        } else {
            errorReporter.enableExceptionHandler();
        }
    }

    @Override
    public void registerUnidentifiedUser() {
        if (this.userIdentity.canRegisterUnidentifiedUser()) {
            this.resetManager.hardReset();
            this.userIdentity.registerUnidentifiedUser();
            this.nexusClient.disconnect();
            Boolean isBackgrounded = this.store.select(Selectors.APP_IS_BACKGROUNDED);
            Boolean newSession = this.store.select(Selectors.SESSION_STARTED_SINCE_LAST_BACKGROUNDED) == false;
            UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(newSession, isBackgrounded, true);
            this.userUpdater.get().updateUser(userUpdateRequest);
        } else {
            this.twig.i("Failed to register user. We already have a registered user. If you are attempting to register a new user, call logout() before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)", new Object[0]);
        }
    }

    @Override
    public void registerIdentifiedUser(@Nullable Registration userRegistration) {
        if (userRegistration == null) {
            this.twig.e("The registration object you passed to is null. An example successful call is registerIdentifiedUser(Registration.create().withEmail(email));", new Object[0]);
            return;
        }
        if (this.userIsRegistered(userRegistration)) {
            this.softRegister();
        } else {
            this.resetManager.hardReset();
            if (this.userIdentity.canRegisterIdentifiedUser(userRegistration)) {
                this.userIdentity.registerIdentifiedUser(userRegistration);
                this.nexusClient.disconnect();
                Boolean newSession = this.store.select(Selectors.SESSION_STARTED_SINCE_LAST_BACKGROUNDED) == false;
                Boolean isInBackground = this.store.select(Selectors.APP_IS_BACKGROUNDED);
                UserUpdateRequest update = userRegistration.getAttributes() != null ? UserUpdateRequest.create(newSession, isInBackground, userRegistration.getAttributes().toMap(), true) : UserUpdateRequest.create(newSession, isInBackground, true);
                this.userUpdater.get().updateUser(update);
            } else if (this.userIdentity.registrationHasAttributes(userRegistration)) {
                this.twig.i("We already have a registered user. Updating this user with the attributes provided.", new Object[0]);
                this.updateUser(userRegistration.getAttributes());
            } else {
                this.twig.i("Failed to register user. We already have a registered user. If you are attempting to register a new user, call logout() before this.", new Object[0]);
            }
        }
    }

    private boolean userIsRegistered(Registration userRegistration) {
        return this.userIdentity.isSoftReset() && this.userIdentity.isSameUser(userRegistration);
    }

    private void softRegister() {
        String deviceToken = DeviceData.getDeviceToken(this.context);
        if (!TextUtils.isEmpty((CharSequence)deviceToken)) {
            this.apiProvider.get().setDeviceToken(deviceToken);
        }
        this.nexusClient.connect(this.appConfigProvider.get().getRealTimeConfig(), true);
        this.userIdentity.softRestart();
        this.resetManager.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RealIntercom.this.overlayPresenter.refreshStateBecauseUserIdentityIsNotInStoreYet();
            }
        };
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            new Handler(Looper.getMainLooper()).post(runnable);
        }
    }

    @Override
    public void setUserHash(String userHash) {
        if (TextUtils.isEmpty((CharSequence)userHash)) {
            this.twig.w("The user hash you sent us to verify was either null or empty, we will not be able to authenticate your requests without a valid user hash.", new Object[0]);
        } else if (this.userIdentity.getHmac().equals(userHash)) {
            this.twig.i("The user hash set matches the existing user identity hash value", new Object[0]);
        } else {
            if (this.userIdentity.softUserIdentityHmacDiffers(userHash)) {
                this.resetManager.hardReset();
            }
            this.userIdentity.setUserHash(userHash);
        }
    }

    @Override
    public void updateUser(@Nullable UserAttributes userAttributes) {
        if (userAttributes == null) {
            this.twig.e("updateUser method failed: the UserAttributes object provided is null", new Object[0]);
        } else {
            this.performUpdate(userAttributes.toMap());
        }
    }

    private void performUpdate(Map<String, Object> userAttributes) {
        if (this.userIdentity.isUnidentified()) {
            AttributeSanitiser.anonymousSanitisation(userAttributes);
        }
        if (this.superDeDuper.shouldUpdateUser(userAttributes)) {
            this.superDeDuper.update(userAttributes);
            Boolean isBackgrounded = this.store.select(Selectors.APP_IS_BACKGROUNDED);
            UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(false, isBackgrounded, userAttributes, false);
            this.userUpdater.get().updateUser(userUpdateRequest);
            this.twig.internal("dupe", "updated user");
        } else {
            this.twig.internal("dupe", "dropped dupe");
        }
    }

    @Override
    public void logEvent(String name) {
        this.logEventWithValidation(name, Collections.emptyMap());
    }

    @Override
    public void logEvent(String name, @Nullable Map<String, ?> metadata) {
        if (metadata == null) {
            this.twig.i("The metadata provided is null, logging event with no metadata", new Object[0]);
            metadata = new HashMap();
        } else if (metadata.isEmpty()) {
            this.twig.i("The metadata provided is empty, logging event with no metadata", new Object[0]);
        }
        this.logEventWithValidation(name, metadata);
    }

    private void logEventWithValidation(String name, Map<String, ?> metadata) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            this.twig.e("The event name is null or empty. We can't log an event with this string.", new Object[0]);
        } else {
            this.apiProvider.get().logEvent(name, metadata);
        }
    }

    @Override
    public void displayMessenger() {
        if (this.noUserRegistered()) {
            this.logErrorAndOpenInbox("The messenger was opened but there was no user registered on this device.Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).");
        } else {
            new LauncherOpenBehaviour(this.store, LauncherOpenBehaviour.LauncherType.CUSTOM, this.metricTracker, this.appConfigProvider).openMessenger(this.context);
        }
    }

    @Override
    public void displayMessageComposer() {
        this.displayMessageComposer("");
    }

    @Override
    public void displayMessageComposer(String initialMessage) {
        if (this.noUserRegistered()) {
            this.logErrorAndOpenInbox("The messenger was opened but there was no user registered on this device. Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).");
        } else if (!this.appConfigProvider.get().isReceivedFromServer()) {
            this.logErrorAndOpenInbox("It appears your app has not received a successful response from Intercom. Please check you are using the correct Android app ID and API Key from the Intercom settings.");
        } else if (!this.appConfigProvider.get().isInboundMessages()) {
            this.logErrorAndOpenInbox("It appears your app is not on a plan that allows message composing. As a fallback we are calling displayConversationsList()");
        } else {
            this.metricTracker.openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType.CUSTOM);
            this.context.startActivity(IntercomMessengerActivity.openComposer(this.context, initialMessage));
        }
    }

    @Override
    public void displayConversationsList() {
        this.metricTracker.openedMessengerConversationList(LauncherOpenBehaviour.LauncherType.CUSTOM);
        this.context.startActivity(IntercomMessengerActivity.openHomeScreen(this.context));
    }

    @Override
    public void displayHelpCenter() {
        if (TextUtils.isEmpty((CharSequence)this.appConfigProvider.get().getHelpCenterUrl())) {
            if (this.noUserRegistered()) {
                this.twig.e("The app config has not been retrieved, please call registerUnidentifiedUser() or registerIdentifiedUser(Registration) before calling displayHelpCenter().", new Object[0]);
                return;
            }
            this.twig.e("Could not open Help Center. Please make sure you have turned on Help Center in Educate settings.", new Object[0]);
            return;
        }
        Intent intent = IntercomHelpCenterActivity.buildIntent(this.context, this.appConfigProvider.get().getHelpCenterUrl(), 1, "");
        this.context.startActivity(intent);
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
        this.store.dispatch(Actions.setBottomPadding(bottomPadding));
    }

    private boolean noUserRegistered() {
        return !this.userIdentity.identityExists() || this.userIdentity.isSoftReset();
    }

    private void logErrorAndOpenInbox(String error) {
        this.twig.e(error, new Object[0]);
        this.displayConversationsList();
    }

    @Override
    public void setInAppMessageVisibility(Intercom.Visibility visibility) {
        this.store.dispatch(Actions.setInAppNotificationVisibility(visibility));
    }

    @Override
    public void setLauncherVisibility(Intercom.Visibility visibility) {
        this.store.dispatch(Actions.setLauncherVisibility(visibility));
    }

    @Override
    public void hideMessenger() {
        this.activityFinisher.finishActivities();
    }

    @Override
    public void handlePushMessage() {
        this.handlePushMessage(null);
    }

    @Override
    public void handlePushMessage(@Nullable TaskStackBuilder customStack) {
        SharedPreferences preferences = this.context.getSharedPreferences("INTERCOM_SDK_PUSH_PREFS", 0);
        String pushDataString = preferences.getString("intercom_push_notification_path", "");
        if (TextUtils.isEmpty((CharSequence)pushDataString)) {
            this.twig.internal("No Uri found");
        } else {
            this.openIntercomChatPush(pushDataString, customStack);
            preferences.edit().clear().apply();
        }
    }

    private void openIntercomChatPush(String pushDataString, @Nullable TaskStackBuilder customStack) {
        Intent messengerIntent = pushDataString.equals("multiple_notifications") ? IntercomMessengerActivity.openInbox(this.context) : IntercomMessengerActivity.openConversation(this.context, pushDataString, LastParticipatingAdmin.NULL);
        if (customStack != null) {
            customStack.addNextIntent(messengerIntent);
            this.context.startActivities(customStack.getIntents());
        } else {
            this.context.startActivity(messengerIntent);
        }
        this.metricTracker.viewedPushNotification(pushDataString);
        this.systemNotificationManager.clear();
    }

    private boolean shouldDisableErrorReporting() {
        return this.appConfigProvider.get().hasFeature("disable-error-reporting");
    }

    @Override
    public void reset() {
        this.logout();
    }

    @Override
    public void logout() {
        if (!this.userIdentity.isSoftReset()) {
            this.resetManager.softReset();
        }
    }

    @Override
    public int getUnreadConversationCount() {
        return this.store.state().unreadConversationIds().size();
    }

    @Override
    public void addUnreadConversationCountListener(UnreadConversationCountListener listener) {
        if (listener != null) {
            this.unreadCountTracker.addListener(listener);
        }
    }

    @Override
    public void removeUnreadConversationCountListener(UnreadConversationCountListener listener) {
        this.unreadCountTracker.removeListener(listener);
    }
}

