/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.request.transition;

import android.graphics.drawable.Drawable;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.request.transition.DrawableCrossFadeTransition;
import io.intercom.com.bumptech.glide.request.transition.NoTransition;
import io.intercom.com.bumptech.glide.request.transition.Transition;
import io.intercom.com.bumptech.glide.request.transition.TransitionFactory;

public class DrawableCrossFadeFactory
implements TransitionFactory<Drawable> {
    private final int duration;
    private final boolean isCrossFadeEnabled;
    private DrawableCrossFadeTransition resourceTransition;

    protected DrawableCrossFadeFactory(int duration, boolean isCrossFadeEnabled) {
        this.duration = duration;
        this.isCrossFadeEnabled = isCrossFadeEnabled;
    }

    @Override
    public Transition<Drawable> build(DataSource dataSource, boolean isFirstResource) {
        return dataSource == DataSource.MEMORY_CACHE ? NoTransition.get() : this.getResourceTransition();
    }

    private Transition<Drawable> getResourceTransition() {
        if (this.resourceTransition == null) {
            this.resourceTransition = new DrawableCrossFadeTransition(this.duration, this.isCrossFadeEnabled);
        }
        return this.resourceTransition;
    }

    public static class Builder {
        private static final int DEFAULT_DURATION_MS = 300;
        private final int durationMillis;
        private boolean isCrossFadeEnabled;

        public Builder() {
            this(300);
        }

        public Builder(int durationMillis) {
            this.durationMillis = durationMillis;
        }

        public Builder setCrossFadeEnabled(boolean isCrossFadeEnabled) {
            this.isCrossFadeEnabled = isCrossFadeEnabled;
            return this;
        }

        public DrawableCrossFadeFactory build() {
            return new DrawableCrossFadeFactory(this.durationMillis, this.isCrossFadeEnabled);
        }
    }
}

