/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.Downsampler;
import io.intercom.com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import io.intercom.com.bumptech.glide.util.ExceptionCatchingInputStream;
import io.intercom.com.bumptech.glide.util.MarkEnforcingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamBitmapDecoder
implements ResourceDecoder<InputStream, Bitmap> {
    private final Downsampler downsampler;
    private final ArrayPool byteArrayPool;

    public StreamBitmapDecoder(Downsampler downsampler, ArrayPool byteArrayPool) {
        this.downsampler = downsampler;
        this.byteArrayPool = byteArrayPool;
    }

    @Override
    public boolean handles(InputStream source2, Options options) throws IOException {
        return this.downsampler.handles(source2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource<Bitmap> decode(InputStream source2, int width, int height, Options options) throws IOException {
        boolean ownsBufferedStream;
        RecyclableBufferedInputStream bufferedStream;
        if (source2 instanceof RecyclableBufferedInputStream) {
            bufferedStream = (RecyclableBufferedInputStream)source2;
            ownsBufferedStream = false;
        } else {
            bufferedStream = new RecyclableBufferedInputStream(source2, this.byteArrayPool);
            ownsBufferedStream = true;
        }
        ExceptionCatchingInputStream exceptionStream = ExceptionCatchingInputStream.obtain(bufferedStream);
        MarkEnforcingInputStream invalidatingStream = new MarkEnforcingInputStream(exceptionStream);
        UntrustedCallbacks callbacks = new UntrustedCallbacks(bufferedStream, exceptionStream);
        try {
            Resource<Bitmap> resource = this.downsampler.decode(invalidatingStream, width, height, options, callbacks);
            return resource;
        }
        finally {
            exceptionStream.release();
            if (ownsBufferedStream) {
                bufferedStream.release();
            }
        }
    }

    static class UntrustedCallbacks
    implements Downsampler.DecodeCallbacks {
        private final RecyclableBufferedInputStream bufferedStream;
        private final ExceptionCatchingInputStream exceptionStream;

        UntrustedCallbacks(RecyclableBufferedInputStream bufferedStream, ExceptionCatchingInputStream exceptionStream) {
            this.bufferedStream = bufferedStream;
            this.exceptionStream = exceptionStream;
        }

        @Override
        public void onObtainBounds() {
            this.bufferedStream.fixMarkLimit();
        }

        @Override
        public void onDecodeComplete(BitmapPool bitmapPool, Bitmap downsampled) throws IOException {
            IOException streamException = this.exceptionStream.getException();
            if (streamException != null) {
                if (downsampled != null) {
                    bitmapPool.put(downsampled);
                }
                throw streamException;
            }
        }
    }
}

