/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.Nullable;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.DrawableToBitmapConverter;
import io.intercom.com.bumptech.glide.load.resource.drawable.ResourceDrawableDecoder;
import java.io.IOException;

public class ResourceBitmapDecoder
implements ResourceDecoder<Uri, Bitmap> {
    private final ResourceDrawableDecoder drawableDecoder;
    private final BitmapPool bitmapPool;

    public ResourceBitmapDecoder(ResourceDrawableDecoder drawableDecoder, BitmapPool bitmapPool) {
        this.drawableDecoder = drawableDecoder;
        this.bitmapPool = bitmapPool;
    }

    @Override
    public boolean handles(Uri source2, Options options) throws IOException {
        return "android.resource".equals(source2.getScheme());
    }

    @Override
    @Nullable
    public Resource<Bitmap> decode(Uri source2, int width, int height, Options options) throws IOException {
        Resource<Drawable> drawableResource = this.drawableDecoder.decode(source2, width, height, options);
        Drawable drawable = drawableResource.get();
        return DrawableToBitmapConverter.convert(this.bitmapPool, drawable, width, height);
    }
}

