/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.support.v4.util.Pools;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelLoaderRegistry {
    private final MultiModelLoaderFactory multiModelLoaderFactory;
    private final ModelLoaderCache cache = new ModelLoaderCache();

    public ModelLoaderRegistry(Pools.Pool<List<Throwable>> throwableListPool) {
        this(new MultiModelLoaderFactory(throwableListPool));
    }

    private ModelLoaderRegistry(MultiModelLoaderFactory multiModelLoaderFactory) {
        this.multiModelLoaderFactory = multiModelLoaderFactory;
    }

    public synchronized <Model, Data> void append(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2) {
        this.multiModelLoaderFactory.append(modelClass, dataClass, factory2);
        this.cache.clear();
    }

    public synchronized <Model, Data> void prepend(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2) {
        this.multiModelLoaderFactory.prepend(modelClass, dataClass, factory2);
        this.cache.clear();
    }

    public synchronized <Model, Data> void remove(Class<Model> modelClass, Class<Data> dataClass) {
        this.tearDown(this.multiModelLoaderFactory.remove(modelClass, dataClass));
        this.cache.clear();
    }

    public synchronized <Model, Data> void replace(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2) {
        this.tearDown(this.multiModelLoaderFactory.replace(modelClass, dataClass, factory2));
        this.cache.clear();
    }

    private <Model, Data> void tearDown(List<ModelLoaderFactory<? extends Model, ? extends Data>> factories) {
        for (ModelLoaderFactory<Model, Data> factory2 : factories) {
            factory2.teardown();
        }
    }

    public synchronized <A> List<ModelLoader<A, ?>> getModelLoaders(A model) {
        List<ModelLoader<A, ?>> modelLoaders = this.getModelLoadersForClass(ModelLoaderRegistry.getClass(model));
        int size = modelLoaders.size();
        ArrayList filteredLoaders = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            ModelLoader<A, ?> loader = modelLoaders.get(i);
            if (!loader.handles(model)) continue;
            filteredLoaders.add(loader);
        }
        return filteredLoaders;
    }

    public synchronized <Model, Data> ModelLoader<Model, Data> build(Class<Model> modelClass, Class<Data> dataClass) {
        return this.multiModelLoaderFactory.build(modelClass, dataClass);
    }

    public synchronized List<Class<?>> getDataClasses(Class<?> modelClass) {
        return this.multiModelLoaderFactory.getDataClasses(modelClass);
    }

    private <A> List<ModelLoader<A, ?>> getModelLoadersForClass(Class<A> modelClass) {
        List loaders = this.cache.get(modelClass);
        if (loaders == null) {
            loaders = Collections.unmodifiableList(this.multiModelLoaderFactory.build(modelClass));
            this.cache.put(modelClass, loaders);
        }
        return loaders;
    }

    private static <A> Class<A> getClass(A model) {
        return model.getClass();
    }

    private static class ModelLoaderCache {
        private final Map<Class<?>, Entry<?>> cachedModelLoaders = new HashMap();

        ModelLoaderCache() {
        }

        public void clear() {
            this.cachedModelLoaders.clear();
        }

        public <Model> void put(Class<Model> modelClass, List<ModelLoader<Model, ?>> loaders) {
            Entry<Model> previous = this.cachedModelLoaders.put(modelClass, new Entry<Model>(loaders));
            if (previous != null) {
                throw new IllegalStateException("Already cached loaders for model: " + modelClass);
            }
        }

        public <Model> List<ModelLoader<Model, ?>> get(Class<Model> modelClass) {
            Entry<?> entry = this.cachedModelLoaders.get(modelClass);
            return entry == null ? null : entry.loaders;
        }

        private static class Entry<Model> {
            final List<ModelLoader<Model, ?>> loaders;

            public Entry(List<ModelLoader<Model, ?>> loaders) {
                this.loaders = loaders;
            }
        }
    }
}

