/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.attribute.AttributeInputListener;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.views.BaseAttributeView;
import io.intercom.android.sdk.views.holder.ConversationListener;

public class ListAttributeView
extends BaseAttributeView
implements AttributeInputListener {
    @VisibleForTesting
    TextView attributeLabel = (TextView)this.findViewById(R.id.attribute_input);

    public ListAttributeView(Context context) {
        this(context, null);
    }

    public ListAttributeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public int getLayoutRes() {
        return R.layout.intercom_view_list_attribute;
    }

    @Override
    public void displayErrorState(String message) {
        this.setError(message);
    }

    public void updateAttributeContent(Attribute attribute) {
        this.setAttribute(attribute);
        if (attribute.hasValue()) {
            this.attributeLabel.setText((CharSequence)attribute.getValue());
            this.attributeLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.intercom_attribute_verified_tick, 0);
        } else {
            this.displayEmptyState();
        }
    }

    @Override
    public void displayEmptyState() {
        this.attributeLabel.setText((CharSequence)"");
        this.attributeLabel.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.intercom_list_arrow_down, 0);
    }

    public void setOnClickListener(final String partId, final ConversationListener conversationListener) {
        if (!this.getAttribute().getValue().isEmpty()) {
            return;
        }
        this.attributeLabel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                conversationListener.onListAttributeClicked(partId, ListAttributeView.this.getAttribute(), ListAttributeView.this);
            }
        });
    }

    @Override
    public void populateSelectedValue(String value) {
        this.attributeLabel.setText((CharSequence)value);
    }
}

