/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.transforms;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.security.MessageDigest;

public final class GreyscaleTransform
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "io.intercom.android.sdk.transforms.GreyscaleTransform.1";

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        int width = toTransform.getWidth();
        int height = toTransform.getHeight();
        Bitmap.Config config = toTransform.getConfig() != null ? toTransform.getConfig() : Bitmap.Config.ARGB_8888;
        Bitmap bitmap = pool.get(width, height, config);
        bitmap.setDensity(toTransform.getDensity());
        Canvas canvas = new Canvas(bitmap);
        ColorMatrix saturation = new ColorMatrix();
        saturation.setSaturation(0.0f);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(saturation));
        canvas.drawBitmap(toTransform, 0.0f, 0.0f, paint);
        return bitmap;
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update(ID.getBytes(CHARSET));
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof GreyscaleTransform;
    }

    public int hashCode() {
        return ID.hashCode();
    }

    public String toString() {
        return "GreyscaleTransform";
    }
}

