/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.ViewCompat;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.AutoCompleteTextView;
import io.intercom.android.sdk.R;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

class MessengerCardAlertDialogBuilder
extends AlertDialog.Builder {
    MessengerCardAlertDialogBuilder(@NonNull Context context, @NonNull Map<String, Object> payload, int primaryColor, @NonNull WebView webView) {
        super(context);
        this.setUp(context, payload, primaryColor, webView);
    }

    private void setUp(Context context, final Map<String, Object> payload, int primaryColor, final WebView webView) {
        View viewInflated = LayoutInflater.from((Context)context).inflate(R.layout.intercom_webview_card_input, null, false);
        this.setTitle((CharSequence)payload.get("label"));
        final AutoCompleteTextView inputView = (AutoCompleteTextView)viewInflated.findViewById(R.id.input);
        inputView.setText((CharSequence)payload.get("currentValue"));
        inputView.setHint((CharSequence)payload.get("placeholder"));
        ColorStateList colorStateList = ColorStateList.valueOf((int)primaryColor);
        ViewCompat.setBackgroundTintList((View)inputView, (ColorStateList)colorStateList);
        this.setView(viewInflated);
        this.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MessengerCardAlertDialogBuilder.this.sendResultToWebview(webView, inputView.getText().toString(), payload);
                InputMethodManager inputMethodManager = (InputMethodManager)inputView.getContext().getSystemService("input_method");
                inputMethodManager.hideSoftInputFromWindow(inputView.getWindowToken(), 0);
                dialog.dismiss();
            }
        });
        this.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                InputMethodManager inputMethodManager = (InputMethodManager)inputView.getContext().getSystemService("input_method");
                inputMethodManager.hideSoftInputFromWindow(inputView.getWindowToken(), 0);
                dialog.cancel();
            }
        });
    }

    @VisibleForTesting
    void sendResultToWebview(WebView webView, String inputText, Map<String, Object> payload) {
        String escapedQuery = "";
        try {
            escapedQuery = URLEncoder.encode(inputText, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String javascriptEvent = "window.fallbackApp.bridgeEvent('UPDATE_TEXT', { value:'" + escapedQuery + "', id:'" + payload.get("id") + "'})";
        webView.evaluateJavascript(javascriptEvent, null);
    }
}

