/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.views.AnimatorEndListener;

public class ExpandableLayout
extends LinearLayout {
    private static final long ANIMATION_DURATION = 100L;
    private int widthMeasureSpec;
    private int heightMeasureSpec;
    private boolean attachedToWindow;
    private boolean firstLayout = true;
    private boolean inLayout;
    private ObjectAnimator expandAnimator;
    private ObjectAnimator fadeAnimator;

    public ExpandableLayout(Context context) {
        super(context);
    }

    public ExpandableLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ExpandableLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.widthMeasureSpec = widthMeasureSpec;
        this.heightMeasureSpec = heightMeasureSpec;
        View child = this.findExpandableView();
        if (child != null) {
            LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
            if (layoutParams.weight != 0.0f) {
                throw new IllegalArgumentException("ExpandableView can't use weight");
            }
            if (!layoutParams.isExpanded && !layoutParams.isExpanding) {
                child.setVisibility(8);
            } else {
                child.setVisibility(0);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.inLayout = true;
        super.onLayout(changed, l, t, r, b);
        this.inLayout = false;
        this.firstLayout = false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attachedToWindow = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.attachedToWindow = false;
        View child = this.findExpandableView();
        this.safeReleaseAnimator(this.expandAnimator);
        this.safeReleaseAnimator(this.fadeAnimator);
        if (child != null) {
            LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
            if (layoutParams.isExpanded) {
                layoutParams.height = layoutParams.originalHeight;
                child.setVisibility(0);
            } else {
                layoutParams.height = layoutParams.originalHeight;
                child.setVisibility(8);
            }
            layoutParams.isExpanding = false;
        }
    }

    private void safeReleaseAnimator(ObjectAnimator animator) {
        if (animator != null && animator.isRunning()) {
            animator.end();
        }
    }

    public void requestLayout() {
        if (!this.inLayout) {
            super.requestLayout();
        }
    }

    public View findExpandableView() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
            if (!layoutParams.canExpand) continue;
            return this.getChildAt(i);
        }
        return null;
    }

    boolean checkExpandableView(View expandableView) {
        LayoutParams layoutParams = (LayoutParams)expandableView.getLayoutParams();
        return layoutParams.canExpand;
    }

    public boolean isExpanded() {
        View child = this.findExpandableView();
        if (child != null) {
            LayoutParams p = (LayoutParams)child.getLayoutParams();
            if (p.isExpanded) {
                return true;
            }
        }
        return false;
    }

    public boolean setExpanded(boolean isExpanded) {
        return this.setExpanded(isExpanded, false);
    }

    public boolean setExpanded(boolean isExpanded, boolean shouldAnimate) {
        boolean result = false;
        View child = this.findExpandableView();
        if (child != null && isExpanded != this.isExpanded()) {
            result = isExpanded ? this.expand(child, shouldAnimate) : this.collapse(child, shouldAnimate);
        }
        this.requestLayout();
        return result;
    }

    private boolean expand(View child, boolean shouldAnimate) {
        boolean result = false;
        if (!this.checkExpandableView(child)) {
            throw new IllegalArgumentException("expand(), View is not expandableView");
        }
        LayoutParams p = (LayoutParams)child.getLayoutParams();
        if (this.firstLayout || !this.attachedToWindow || !shouldAnimate) {
            p.isExpanded = true;
            p.isExpanding = false;
            p.height = p.originalHeight;
            child.setVisibility(0);
            result = true;
        } else if (!p.isExpanded && !p.isExpanding) {
            this.playExpandAnimation(child);
            result = true;
        }
        return result;
    }

    private void playExpandAnimation(final View child) {
        LayoutParams p = (LayoutParams)child.getLayoutParams();
        if (p.isExpanding) {
            return;
        }
        child.setVisibility(0);
        p.isExpanding = true;
        this.measure(this.widthMeasureSpec, this.heightMeasureSpec);
        int measuredHeight = child.getMeasuredHeight();
        p.height = 0;
        this.expandAnimator = ObjectAnimator.ofInt((Object)((Object)p), (String)"height", (int[])new int[]{0, measuredHeight});
        this.expandAnimator.setDuration(100L);
        this.expandAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                child.requestLayout();
            }
        });
        this.expandAnimator.addListener((Animator.AnimatorListener)new AnimatorEndListener(){

            public void onAnimationEnd(Animator animation) {
                ExpandableLayout.this.performToggleState(child);
            }
        });
        child.setAlpha(0.0f);
        this.fadeAnimator = ObjectAnimator.ofFloat((Object)child, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
        this.fadeAnimator.setDuration(100L);
        this.fadeAnimator.addListener((Animator.AnimatorListener)new AnimatorEndListener(){

            public void onAnimationEnd(Animator animation) {
                child.setAlpha(1.0f);
            }
        });
        this.fadeAnimator.setStartDelay(200L);
        this.expandAnimator.start();
        this.fadeAnimator.start();
    }

    private boolean collapse(View child, boolean shouldAnimation) {
        boolean result = false;
        if (!this.checkExpandableView(child)) {
            throw new IllegalArgumentException("collapse(), View is not expandableView");
        }
        LayoutParams p = (LayoutParams)child.getLayoutParams();
        if (this.firstLayout || !this.attachedToWindow || !shouldAnimation) {
            p.isExpanded = false;
            p.isExpanding = false;
            p.height = p.originalHeight;
            child.setVisibility(8);
            result = true;
        } else if (p.isExpanded && !p.isExpanding) {
            this.playCollapseAnimation(child);
            result = true;
        }
        return result;
    }

    private void playCollapseAnimation(final View child) {
        LayoutParams p = (LayoutParams)child.getLayoutParams();
        if (p.isExpanding) {
            return;
        }
        child.setVisibility(0);
        p.isExpanding = true;
        this.measure(this.widthMeasureSpec, this.heightMeasureSpec);
        int measuredHeight = child.getMeasuredHeight();
        this.expandAnimator = ObjectAnimator.ofInt((Object)((Object)p), (String)"height", (int[])new int[]{measuredHeight, 0});
        this.expandAnimator.setDuration(100L);
        this.expandAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                child.requestLayout();
            }
        });
        this.expandAnimator.addListener((Animator.AnimatorListener)new AnimatorEndListener(){

            public void onAnimationEnd(Animator animation) {
                ExpandableLayout.this.performToggleState(child);
            }
        });
        child.setAlpha(0.0f);
        this.fadeAnimator = ObjectAnimator.ofFloat((Object)child, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f});
        this.fadeAnimator.setDuration(100L);
        this.fadeAnimator.addListener((Animator.AnimatorListener)new AnimatorEndListener(){

            public void onAnimationEnd(Animator animation) {
                child.setAlpha(0.0f);
            }
        });
        this.expandAnimator.setStartDelay(200L);
        this.fadeAnimator.start();
        this.expandAnimator.start();
    }

    void performToggleState(View child) {
        LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
        if (layoutParams.isExpanded) {
            layoutParams.isExpanded = false;
            child.setVisibility(8);
            layoutParams.height = layoutParams.originalHeight;
        } else {
            layoutParams.isExpanded = true;
        }
        layoutParams.isExpanding = false;
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.isExpanded()) {
            savedState.isExpanded = true;
        }
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View child;
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.isExpanded && (child = this.findExpandableView()) != null) {
            this.setExpanded(true);
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return super.checkLayoutParams(p) && p instanceof LayoutParams;
    }

    private static class LayoutParams
    extends LinearLayout.LayoutParams {
        private static final int NO_MEASURED_HEIGHT = -10;
        int originalHeight = -10;
        boolean isExpanded;
        boolean canExpand;
        boolean isExpanding;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ExpandableLayout);
            this.canExpand = a.getBoolean(R.styleable.ExpandableLayout_intercomCanExpand, false);
            this.originalHeight = this.height;
            a.recycle();
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
            this.originalHeight = this.height;
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.originalHeight = this.height;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
            this.originalHeight = this.height;
        }

        public LayoutParams(LinearLayout.LayoutParams source) {
            super(source);
            this.originalHeight = this.height;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
            this.originalHeight = this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        boolean isExpanded;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.isExpanded = source.readInt() == 1;
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isExpanded ? 1 : 0);
        }
    }
}

