/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.profile.ProfilePresenter;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;
import io.intercom.android.sdk.profile.TeamProfileToolbarBehavior;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.WindowUtils;
import io.intercom.android.sdk.views.OfficeHoursTextView;
import io.intercom.com.bumptech.glide.RequestManager;
import java.util.Arrays;
import java.util.List;

class TeamProfilePresenter {
    private final ViewGroup rootLayout;
    private final ViewGroup contentView;
    private final LinearLayout avatarLayout;
    private final ProfileToolbarBehavior toolbarBehavior;
    private final TextView collapsedToolbarTitle;
    private final OfficeHoursTextView collapsedOfficeHours;
    private final ImageView wallpaperImageView;
    private final List<ImageView> avatarViews;
    private final List<TextView> adminNameViews;
    private final TextView bioView;
    private final ProfilePresenter profilePresenter;
    private final Provider<AppConfig> appConfigProvider;
    private boolean shouldAddTransformHeight = true;

    TeamProfilePresenter(CoordinatorLayout rootView, ProfilePresenter profilePresenter, Provider<AppConfig> appConfigProvider) {
        this.profilePresenter = profilePresenter;
        this.rootLayout = (ViewGroup)rootView.findViewById(R.id.intercom_team_profile);
        this.contentView = (ViewGroup)this.rootLayout.findViewById(R.id.toolbar_content_container);
        this.appConfigProvider = appConfigProvider;
        this.rootLayout.setBackgroundColor(appConfigProvider.get().getSecondaryColor());
        this.rootLayout.setAlpha(0.0f);
        this.collapsedToolbarTitle = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_title);
        this.collapsedOfficeHours = (OfficeHoursTextView)this.rootLayout.findViewById(R.id.intercom_collapsing_office_hours);
        this.avatarLayout = (LinearLayout)this.rootLayout.findViewById(R.id.intercom_team_profiles_layout);
        this.avatarViews = Arrays.asList((ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_avatar1), (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_avatar2), (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_avatar3));
        this.adminNameViews = Arrays.asList((TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_name_1), (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_name_2), (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_name_3));
        this.bioView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_bio);
        this.toolbarBehavior = new TeamProfileToolbarBehavior(this.rootLayout);
        this.wallpaperImageView = (ImageView)this.rootLayout.findViewById(R.id.team_wallpaper_image);
        profilePresenter.loadWallpaperInto(this.wallpaperImageView);
        this.updateColors(appConfigProvider.get().secondaryColorRenderDarkText());
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.contentView.getLayoutParams();
        params.setMargins(params.leftMargin, params.topMargin + WindowUtils.getStatusBarHeight(this.contentView.getResources()), params.rightMargin, params.bottomMargin);
        this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.contentView.startAnimation(AnimationUtils.loadAnimation((Context)this.contentView.getContext(), (int)R.anim.intercom_profile_slide_in));
    }

    ViewGroup getRootLayout() {
        return this.rootLayout;
    }

    ProfileToolbarBehavior getToolbarBehavior() {
        return this.toolbarBehavior;
    }

    void setPresence(TeamPresence teamPresence, int maxWidth, AppBarLayout appBarLayout, View teammateLayout, View titleLayoutCoordinator, RequestManager requestManager) {
        List<Participant> admins;
        Context context = this.rootLayout.getContext();
        appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.toolbarBehavior);
        if (this.rootLayout.getAlpha() < 1.0f || this.avatarLayout.getVisibility() == 8) {
            teammateLayout.setAlpha(0.0f);
            this.rootLayout.setAlpha(1.0f);
            if (this.profilePresenter.isDidShowUnknown()) {
                titleLayoutCoordinator.requestLayout();
                appBarLayout.setExpanded(true, true);
                this.profilePresenter.setDidShowUnknown(false);
            }
        }
        if ((admins = teamPresence.getActiveAdmins()).isEmpty()) {
            this.avatarLayout.setVisibility(8);
        } else {
            this.avatarLayout.setVisibility(0);
            String officeHours = teamPresence.getOfficeHours();
            if (TextUtils.isEmpty((CharSequence)officeHours)) {
                this.collapsedOfficeHours.setText(teamPresence.getExpectedResponseDelay());
            } else {
                this.collapsedOfficeHours.setText(officeHours);
                int imageColor = ColorUtils.whiteOrBlackColor(context, this.appConfigProvider.get().secondaryColorRenderDarkText());
                this.collapsedOfficeHours.setOfficeHoursDrawable(imageColor);
            }
            for (int i = 0; i < this.avatarViews.size() && i < admins.size(); ++i) {
                ImageView avatarView = this.avatarViews.get(i);
                TextView nameTextView = this.adminNameViews.get(i);
                Participant admin = admins.get(i);
                this.setAvatar(admin.getAvatar(), avatarView, requestManager);
                avatarView.setVisibility(0);
                nameTextView.setText((CharSequence)admin.getForename());
                nameTextView.setVisibility(0);
            }
        }
        this.setProfileTextView(this.bioView, this.appConfigProvider.get().getTeamProfileBio());
        if (maxWidth == 0) {
            maxWidth = ScreenUtils.getScreenDimensions((Context)context).x;
        }
        int originalMaxLines = 1;
        originalMaxLines = this.collapsedOfficeHours.getMaxLines();
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)0x40000000);
        this.rootLayout.measure(widthSpec, 0);
        Resources resources = context.getResources();
        int layoutHeight = this.rootLayout.getMeasuredHeight();
        if (this.shouldAddTransformHeight) {
            layoutHeight += resources.getDimensionPixelSize(R.dimen.intercom_team_profile_translation_y);
            this.shouldAddTransformHeight = false;
        }
        titleLayoutCoordinator.getLayoutParams().height = layoutHeight;
        this.rootLayout.getLayoutParams().height = resources.getDimensionPixelSize(R.dimen.intercom_toolbar_height);
        titleLayoutCoordinator.requestLayout();
        this.collapsedOfficeHours.setMaxLines(originalMaxLines);
        this.wallpaperImageView.getLayoutParams().height = layoutHeight;
        this.rootLayout.requestLayout();
        this.profilePresenter.applyOffsetChangedListener(this.toolbarBehavior);
    }

    private void setProfileTextView(TextView textView, CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            textView.setVisibility(8);
        } else {
            textView.setVisibility(0);
            textView.setText(text);
        }
    }

    private void setAvatar(Avatar avatar, ImageView imageView, RequestManager requestManager) {
        imageView.setVisibility(0);
        AvatarUtils.loadAvatarIntoView(avatar, imageView, this.appConfigProvider.get(), requestManager);
    }

    private void updateColors(boolean secondaryColorRenderDarkText) {
        ColorUtils.setTextColorWhiteOrBlack(this.collapsedToolbarTitle, secondaryColorRenderDarkText);
        ColorUtils.setTextColorWhiteOrBlack((TextView)this.collapsedOfficeHours, secondaryColorRenderDarkText);
        ColorUtils.setTextColorWhiteOrBlack(this.bioView, secondaryColorRenderDarkText);
        for (TextView adminName : this.adminNameViews) {
            ColorUtils.setTextColorWhiteOrBlack(adminName, secondaryColorRenderDarkText);
        }
    }

    void setTeamCollapsingTitle(@Nullable CharSequence title) {
        this.collapsedToolbarTitle.setText(title);
    }
}

