/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models.carousel;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.carousel.AutoValue_Appearance;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class Appearance
implements Parcelable {
    public static Appearance NULL = new Builder().build();
    public static final Parcelable.Creator<Appearance> CREATOR = new Parcelable.Creator<Appearance>(){

        public Appearance createFromParcel(Parcel in) {
            return Appearance.create(in.readString(), in.readString(), in.readString());
        }

        public Appearance[] newArray(int size) {
            return new Appearance[size];
        }
    };

    static Appearance create(String type, String alignment, String textColor) {
        return new AutoValue_Appearance(type, alignment, textColor);
    }

    public abstract String getType();

    public abstract String getAlignment();

    public abstract String getTextColor();

    public Builder toBuilder() {
        return new Builder().withType(this.getType()).withTextAlignment(this.getAlignment()).withTextColor(this.getTextColor());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getType());
        dest.writeString(this.getAlignment());
        dest.writeString(this.getTextColor());
    }

    public static final class Builder {
        @Nullable
        String type;
        @Nullable
        String alignment;
        @Nullable
        String text_color;

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withTextAlignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder withTextColor(String textColor) {
            this.text_color = textColor;
            return this;
        }

        public Appearance build() {
            return Appearance.create(NullSafety.valueOrEmpty(this.type), NullSafety.valueOrEmpty(this.alignment), NullSafety.valueOrEmpty(this.text_color));
        }
    }
}

