/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.views.BaseAttributeView;
import io.intercom.android.sdk.views.holder.ConversationListener;

public class BooleanAttributeView
extends BaseAttributeView {
    @VisibleForTesting
    final TextView yes = (TextView)this.findViewById(R.id.yes);
    @VisibleForTesting
    final TextView no = (TextView)this.findViewById(R.id.no);

    public BooleanAttributeView(Context context) {
        this(context, null);
    }

    public BooleanAttributeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public int getLayoutRes() {
        return R.layout.intercom_view_boolean_attribute;
    }

    @Override
    public void displayErrorState(String message) {
        this.setError(message);
    }

    @Override
    public void displayEmptyState() {
        ColorStateList selectedTextColor = ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.intercom_boolean_attribute_selected_text_selector);
        this.yes.setTextColor(selectedTextColor);
        this.no.setTextColor(selectedTextColor);
        int whiteColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_white);
        int borderColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_attribute_input_outline);
        BackgroundUtils.setRippleButtonBackgroundColor(this.yes.getBackground(), R.id.background, whiteColor);
        BackgroundUtils.setRippleButtonBackgroundColor(this.no.getBackground(), R.id.background, whiteColor);
        BackgroundUtils.setRippleButtonStroke(this.getContext(), this.yes.getBackground(), R.id.background, borderColor);
        BackgroundUtils.setRippleButtonStroke(this.getContext(), this.no.getBackground(), R.id.background, borderColor);
        this.yes.setAlpha(1.0f);
        this.no.setAlpha(1.0f);
        this.yes.setEnabled(true);
        this.no.setEnabled(true);
    }

    public void updateAttributeContent(Attribute attribute) {
        this.setAttribute(attribute);
        if (attribute.hasValue()) {
            boolean isTrue = attribute.getValue().equals(Boolean.TRUE.toString());
            this.showSelectedState(isTrue);
        } else {
            this.displayEmptyState();
        }
    }

    private void showSelectedState(boolean isTrue) {
        ColorStateList selectedTextColor = ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.intercom_boolean_attribute_selected_text_selector);
        ColorStateList nonSelectedTextColor = ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.intercom_boolean_attribute_nonselected_text_selector);
        int selectedBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_attribute_selected_background);
        int whiteColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_white);
        int borderColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_attribute_input_outline);
        this.yes.setTextColor(isTrue ? selectedTextColor : nonSelectedTextColor);
        this.no.setTextColor(isTrue ? nonSelectedTextColor : selectedTextColor);
        this.yes.setAlpha(isTrue ? 1.0f : 0.5f);
        this.no.setAlpha(isTrue ? 0.5f : 1.0f);
        BackgroundUtils.setRippleButtonBackgroundColor(this.yes.getBackground(), R.id.background, isTrue ? selectedBackgroundColor : whiteColor);
        BackgroundUtils.setRippleButtonBackgroundColor(this.no.getBackground(), R.id.background, isTrue ? whiteColor : selectedBackgroundColor);
        BackgroundUtils.setRippleButtonStroke(this.getContext(), this.yes.getBackground(), R.id.background, borderColor);
        BackgroundUtils.setRippleButtonStroke(this.getContext(), this.no.getBackground(), R.id.background, borderColor);
        this.yes.setEnabled(false);
        this.no.setEnabled(false);
    }

    public void setOnSubmitClickListener(final String partId, final ConversationListener conversationListener) {
        this.yes.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BooleanAttributeView.this.showSelectedState(true);
                Attribute attribute = BooleanAttributeView.this.getAttribute();
                conversationListener.onSubmitAttribute(partId, attribute.getIdentifier(), true, attribute.getType());
            }
        });
        this.no.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BooleanAttributeView.this.showSelectedState(false);
                Attribute attribute = BooleanAttributeView.this.getAttribute();
                conversationListener.onSubmitAttribute(partId, attribute.getIdentifier(), false, attribute.getType());
            }
        });
    }
}

