/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load;

import android.support.annotation.Nullable;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.util.Preconditions;
import java.security.MessageDigest;

public final class Option<T> {
    private static final CacheKeyUpdater<Object> EMPTY_UPDATER = new CacheKeyUpdater<Object>(){

        @Override
        public void update(byte[] keyBytes, Object value, MessageDigest messageDigest) {
        }
    };
    private final T defaultValue;
    private final CacheKeyUpdater<T> cacheKeyUpdater;
    private final String key;
    private volatile byte[] keyBytes;

    public static <T> Option<T> memory(String key) {
        return new Option<Object>(key, null, Option.emptyUpdater());
    }

    public static <T> Option<T> memory(String key, T defaultValue) {
        return new Option<T>(key, defaultValue, Option.emptyUpdater());
    }

    public static <T> Option<T> disk(String key, CacheKeyUpdater<T> cacheKeyUpdater) {
        return new Option<Object>(key, null, cacheKeyUpdater);
    }

    public static <T> Option<T> disk(String key, T defaultValue, CacheKeyUpdater<T> cacheKeyUpdater) {
        return new Option<T>(key, defaultValue, cacheKeyUpdater);
    }

    private Option(String key, T defaultValue, CacheKeyUpdater<T> cacheKeyUpdater) {
        this.key = Preconditions.checkNotEmpty(key);
        this.defaultValue = defaultValue;
        this.cacheKeyUpdater = Preconditions.checkNotNull(cacheKeyUpdater);
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void update(T value, MessageDigest messageDigest) {
        this.cacheKeyUpdater.update(this.getKeyBytes(), value, messageDigest);
    }

    private byte[] getKeyBytes() {
        if (this.keyBytes == null) {
            this.keyBytes = this.key.getBytes(Key.CHARSET);
        }
        return this.keyBytes;
    }

    public boolean equals(Object o) {
        if (o instanceof Option) {
            Option other = (Option)o;
            return this.key.equals(other.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    private static <T> CacheKeyUpdater<T> emptyUpdater() {
        return EMPTY_UPDATER;
    }

    public String toString() {
        return "Option{key='" + this.key + '\'' + '}';
    }

    public static interface CacheKeyUpdater<T> {
        public void update(byte[] var1, T var2, MessageDigest var3);
    }
}

