/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.RequestBuilder;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.Target;
import java.io.IOException;

public class NetworkImage
extends Image
implements ImageBlock {
    private static final int PROGRESSBAR_DIAMETER_DP = 40;
    private final UploadingImageCache uploadingImageCache;
    private final ImageClickListener listener;
    private final RequestManager requestManager;
    private final Twig twig = LumberMill.getLogger();

    NetworkImage(StyleType style2, UploadingImageCache uploadingImageCache, ImageClickListener listener, RequestManager requestManager) {
        super(style2);
        this.uploadingImageCache = uploadingImageCache;
        this.listener = listener;
        this.requestManager = requestManager;
    }

    public View addImage(String url, String linkUrl, int width, int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        Context context = parent.getContext();
        int widthPx = ScreenUtils.dpToPx((float)width, (Context)context);
        int heightPx = ScreenUtils.dpToPx((float)height, (Context)context);
        FrameLayout rootView = new FrameLayout(context);
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        ResizableImageView imageView = new ResizableImageView(context);
        if (Build.VERSION.SDK_INT >= 21) {
            imageView.setTransitionName("lightbox_image");
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        this.setBackground((ImageView)imageView);
        ProgressBar spinner = new ProgressBar(context);
        int spinnerDiameterPx = ScreenUtils.dpToPx((float)40.0f, (Context)context);
        spinner.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(spinnerDiameterPx, spinnerDiameterPx, 17));
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_progress_wheel);
        spinner.setIndeterminateDrawable(drawable2);
        spinner.setIndeterminate(true);
        rootView.addView((View)imageView);
        rootView.addView((View)spinner);
        this.loadImageFromUrl(url, linkUrl, context, widthPx, heightPx, imageView, spinner);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }

    private void loadImageFromUrl(final String url, final String linkUrl, final Context context, final int widthPx, final int heightPx, final ResizableImageView imageView, final ProgressBar spinner) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.hideLoadingState(spinner, (ImageView)imageView);
            imageView.setImageResource(R.drawable.intercom_error);
            return;
        }
        RequestBuilder requestCreator = this.requestManager.load(url);
        this.setImageViewBounds(widthPx, heightPx, imageView, requestCreator);
        Resources resources = context.getResources();
        RequestOptions requestOptions = new RequestOptions().transform((Transformation)new RoundedCornersTransform(resources.getDimensionPixelSize(R.dimen.intercom_image_rounded_corners))).error(R.drawable.intercom_error).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url));
        Uri localImageUri = this.uploadingImageCache.getLocalImageUriForRemoteUrl(url);
        if (localImageUri != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            options.inSampleSize = this.getSampleSize(widthPx, heightPx, displayMetrics);
            try {
                Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)localImageUri);
                BitmapDrawable localImage = new BitmapDrawable(resources, bitmap);
                localImage.setColorFilter(ColorUtils.newGreyscaleFilter());
                requestOptions = requestOptions.placeholder((Drawable)localImage).dontAnimate();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        requestCreator.apply(requestOptions).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                NetworkImage.this.hideLoadingState(spinner, (ImageView)imageView);
                NetworkImage.this.twig.internal("images", "FAILURE");
                return false;
            }

            public boolean onResourceReady(Drawable drawable2, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                NetworkImage.this.twig.internal("images", "SUCCESS");
                NetworkImage.this.hideLoadingState(spinner, (ImageView)imageView);
                if (NetworkImage.this.getStyle() != StyleType.CHAT_FULL) {
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                            NetworkImage.this.listener.onImageClicked(url, linkUrl, (ImageView)imageView, widthPx, heightPx);
                        }
                    });
                }
                return false;
            }
        }).into((ImageView)imageView);
    }

    @VisibleForTesting
    int getSampleSize(int scaledWidth, int scaledHeight, DisplayMetrics displayMetrics) {
        int sampleSize = 1;
        if (scaledWidth > displayMetrics.widthPixels || scaledHeight > displayMetrics.heightPixels) {
            sampleSize = (int)Math.pow(2.0, (int)Math.ceil(Math.log((double)displayMetrics.widthPixels / (double)Math.max(scaledHeight, scaledWidth)) / Math.log(0.5)));
        }
        return sampleSize;
    }

    void hideLoadingState(ProgressBar spinner, ImageView imageView) {
        if (spinner != null) {
            spinner.setVisibility(8);
            imageView.setBackgroundResource(17170445);
        }
    }
}

