/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.text.TextUtils;
import android.transition.ChangeBounds;
import android.transition.Transition;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CookieManager;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.experimental.Intercom;
import io.intercom.android.sdk.helpcenter.HelpCenterListener;
import io.intercom.android.sdk.helpcenter.HelpCenterWebViewPresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.google.gson.Gson;

public class IntercomHelpCenterActivity
extends IntercomBaseActivity
implements IntercomToolbar.Listener,
HelpCenterListener {
    public static final String LINK_TRANSITION_KEY = "link_background";
    private static final String PARCEL_HELP_CENTER_URL = "parcel_help_center_url";
    public static final String PARCEL_DISPLAY_MODE = "parcel_display_mode";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final int ENTRANCE_ANIMATION_TIME_MS = 300;
    private static final int EXIT_ANIMATION_TIME_MS = 150;
    @DisplayMode
    int displayMode = 1;
    String conversationId = "";
    ProgressBar loadingView;
    WebView webView;
    MetricTracker metricTracker;
    private HelpCenterWebViewPresenter presenter;
    private IntercomToolbar intercomToolbar;
    private View containerView;
    private JavascriptRunner jsRunner;
    private Gson gson;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector = Injector.get();
        this.metricTracker = injector.getMetricTracker();
        AppConfig appConfig = injector.getAppConfigProvider().get();
        int backgroundColor = appConfig.getHelpCenterBaseColor();
        Bundle data = this.getIntent().getExtras();
        String helpCenterUrl = "";
        if (data != null) {
            helpCenterUrl = data.getString(PARCEL_HELP_CENTER_URL, "");
            this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
            this.displayMode = data.getInt(PARCEL_DISPLAY_MODE, 1);
        }
        if (this.displayMode == 1) {
            this.setContentView(R.layout.intercom_activity_help_center_fullscreen);
            this.insertWebView();
            this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
            this.intercomToolbar.setTitle(R.string.intercom_help_center);
            this.intercomToolbar.setUpHelpCenterToolbar(appConfig);
            this.intercomToolbar.setListener(this);
            this.intercomToolbar.setSubtitleVisibility(8);
            this.intercomToolbar.setBackgroundColor(backgroundColor);
            this.intercomToolbar.setBackgroundColor(backgroundColor);
            this.intercomToolbar.updateToolbarSize();
            this.containerView = this.findViewById(R.id.link_root);
            this.containerView.setVisibility(8);
            this.containerView.post(new Runnable(){

                @Override
                public void run() {
                    IntercomHelpCenterActivity.this.animateWindowIn();
                }
            });
        } else {
            this.setContentView(R.layout.intercom_activity_help_center);
            this.insertWebView();
            this.webView.setBackgroundResource(R.drawable.intercom_conversation_card_background);
            this.findViewById(R.id.dismiss).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    IntercomHelpCenterActivity.this.metricTracker.closedHelpCenter(IntercomHelpCenterActivity.this.conversationId, 0);
                    IntercomHelpCenterActivity.this.closeHelpCenter();
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)helpCenterUrl)) {
            this.closeHelpCenter();
        }
        this.loadingView = (ProgressBar)this.findViewById(R.id.loading_view);
        this.jsRunner = new JavascriptRunner(this.webView);
        this.gson = injector.getGson();
        this.presenter = new HelpCenterWebViewPresenter(this.webView, this.jsRunner, helpCenterUrl, this.gson, this.metricTracker, injector.getAppConfigProvider(), injector.getStore(), injector.getApiProvider(), injector.getUserIdentity(), injector.getAppIdentity(), CookieManager.getInstance(), this);
        if (this.isFullScreenWithExperimentalMessenger()) {
            this.presenter.setUpMessenger(Intercom.client());
        }
        this.presenter.setUpWebView();
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setSharedElementEnterTransition(this.enterTransition());
            this.getWindow().setSharedElementReturnTransition(this.returnTransition());
            this.findViewById(R.id.link_view).setTransitionName(LINK_TRANSITION_KEY);
        }
        this.presenter.loadBundle();
    }

    private void insertWebView() {
        try {
            this.webView = new WebView((Context)this);
        }
        catch (Resources.NotFoundException e) {
            this.webView = new WebView(this.getApplicationContext());
        }
        this.webView.setAlpha(0.0f);
        this.webView.setId(R.id.intercom_help_center_webview);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        FrameLayout linkView = (FrameLayout)this.findViewById(R.id.link_view);
        linkView.addView((View)this.webView, 0);
    }

    void closeHelpCenter() {
        this.hideKeyboard();
        if (this.isFullScreenWithExperimentalMessenger()) {
            this.presenter.resetMessengerToHostState(Intercom.client());
            this.animateWindowOut();
        } else {
            this.fadeOutView((View)this.webView);
            this.supportFinishAfterTransition();
        }
    }

    private void fadeOutView(View view) {
        view.animate().alpha(0.0f).setDuration(150L).start();
    }

    public void onBackPressed() {
        if (this.webView.canGoBack()) {
            this.webView.goBack();
        } else {
            this.metricTracker.closedHelpCenter(this.conversationId, 1);
            this.closeHelpCenter();
        }
    }

    private boolean isFullScreenWithExperimentalMessenger() {
        return this.displayMode == 1 && Intercom.isBooted();
    }

    public static Intent buildIntent(Context context, String helpCenterUrl, @DisplayMode int displayMode, String conversationId) {
        Intent intent = new Intent(context, IntercomHelpCenterActivity.class);
        intent.putExtra(PARCEL_HELP_CENTER_URL, helpCenterUrl);
        intent.putExtra(PARCEL_DISPLAY_MODE, displayMode);
        intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        intent.setFlags(0x10000000);
        return intent;
    }

    @TargetApi(value=19)
    private Transition enterTransition() {
        ChangeBounds bounds = new ChangeBounds();
        bounds.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        bounds.setDuration(300L);
        return bounds;
    }

    @TargetApi(value=19)
    private Transition returnTransition() {
        ChangeBounds bounds = new ChangeBounds();
        bounds.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        bounds.setDuration(150L);
        return bounds;
    }

    private void animateWindowIn() {
        this.containerView.setVisibility(0);
        this.containerView.setY((float)this.findViewById(0x1020002).getMeasuredHeight());
        this.containerView.animate().y(0.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).setDuration(350L).start();
    }

    private void animateWindowOut() {
        this.containerView.animate().y((float)this.getWindow().getDecorView().getHeight()).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(600L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomHelpCenterActivity.this.finish();
                IntercomHelpCenterActivity.this.overridePendingTransition(0, 0);
            }
        }).start();
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    @Override
    public void onCloseClicked() {
        this.metricTracker.closedHelpCenter(this.conversationId, 0);
        this.closeHelpCenter();
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
    }

    @Override
    public void onWebViewFinishedLoad() {
        this.jsRunner.runPendingScripts();
        this.webView.animate().alpha(1.0f).setDuration(300L).start();
        this.loadingView.setVisibility(8);
        this.metricTracker.viewedHelpCenter(this.conversationId);
    }

    public static @interface DisplayMode {
        public static final int POP_UP = 0;
        public static final int FULL_SCREEN = 1;
    }
}

