/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;

class ProfileExpansionLogic {
    ProfileExpansionLogic() {
    }

    boolean shouldExpandProfile(Conversation conversation) {
        return ProfileExpansionLogic.hasOnlyUserParts(conversation) || ProfileExpansionLogic.hasNoUserReplies(conversation);
    }

    private static boolean hasOnlyUserParts(Conversation conversation) {
        for (Part part : conversation.getParts()) {
            if (!part.isAdmin()) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNoUserReplies(Conversation conversation) {
        boolean hasAdminPart = false;
        for (Part part : conversation.getParts()) {
            if (part.isAdmin()) {
                hasAdminPart = true;
            }
            if (!hasAdminPart || part.isAdmin()) continue;
            return false;
        }
        return true;
    }
}

