/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.engine.EngineResource;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.Util;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class ActiveResources {
    private static final int MSG_CLEAN_REF = 1;
    private final boolean isActiveResourceRetentionAllowed;
    private final Handler mainHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                ActiveResources.this.cleanupActiveReference((ResourceWeakReference)msg.obj);
                return true;
            }
            return false;
        }
    });
    @VisibleForTesting
    final Map<Key, ResourceWeakReference> activeEngineResources = new HashMap<Key, ResourceWeakReference>();
    private EngineResource.ResourceListener listener;
    @Nullable
    private ReferenceQueue<EngineResource<?>> resourceReferenceQueue;
    @Nullable
    private Thread cleanReferenceQueueThread;
    private volatile boolean isShutdown;
    @Nullable
    private volatile DequeuedResourceCallback cb;

    ActiveResources(boolean isActiveResourceRetentionAllowed) {
        this.isActiveResourceRetentionAllowed = isActiveResourceRetentionAllowed;
    }

    void setListener(EngineResource.ResourceListener listener) {
        this.listener = listener;
    }

    void activate(Key key, EngineResource<?> resource) {
        ResourceWeakReference toPut = new ResourceWeakReference(key, resource, this.getReferenceQueue(), this.isActiveResourceRetentionAllowed);
        ResourceWeakReference removed = this.activeEngineResources.put(key, toPut);
        if (removed != null) {
            removed.reset();
        }
    }

    void deactivate(Key key) {
        ResourceWeakReference removed = this.activeEngineResources.remove(key);
        if (removed != null) {
            removed.reset();
        }
    }

    @Nullable
    EngineResource<?> get(Key key) {
        ResourceWeakReference activeRef = this.activeEngineResources.get(key);
        if (activeRef == null) {
            return null;
        }
        EngineResource active = (EngineResource)activeRef.get();
        if (active == null) {
            this.cleanupActiveReference(activeRef);
        }
        return active;
    }

    private void cleanupActiveReference(@NonNull ResourceWeakReference ref) {
        Util.assertMainThread();
        this.activeEngineResources.remove(ref.key);
        if (!ref.isCacheable || ref.resource == null) {
            return;
        }
        EngineResource newResource = new EngineResource(ref.resource, true, false);
        newResource.setResourceListener(ref.key, this.listener);
        this.listener.onResourceReleased(ref.key, newResource);
    }

    private ReferenceQueue<EngineResource<?>> getReferenceQueue() {
        if (this.resourceReferenceQueue == null) {
            this.resourceReferenceQueue = new ReferenceQueue();
            this.cleanReferenceQueueThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    while (!ActiveResources.this.isShutdown) {
                        try {
                            ResourceWeakReference ref = (ResourceWeakReference)ActiveResources.this.resourceReferenceQueue.remove();
                            ActiveResources.this.mainHandler.obtainMessage(1, (Object)ref).sendToTarget();
                            DequeuedResourceCallback current = ActiveResources.this.cb;
                            if (current == null) continue;
                            current.onResourceDequeued();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }, "glide-active-resources");
            this.cleanReferenceQueueThread.start();
        }
        return this.resourceReferenceQueue;
    }

    @VisibleForTesting
    void setDequeuedResourceCallback(DequeuedResourceCallback cb) {
        this.cb = cb;
    }

    @VisibleForTesting
    void shutdown() {
        this.isShutdown = true;
        if (this.cleanReferenceQueueThread == null) {
            return;
        }
        this.cleanReferenceQueueThread.interrupt();
        try {
            this.cleanReferenceQueueThread.join(TimeUnit.SECONDS.toMillis(5L));
            if (this.cleanReferenceQueueThread.isAlive()) {
                throw new RuntimeException("Failed to join in time");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    static final class ResourceWeakReference
    extends WeakReference<EngineResource<?>> {
        final Key key;
        final boolean isCacheable;
        @Nullable
        Resource<?> resource;

        ResourceWeakReference(@NonNull Key key, @NonNull EngineResource<?> referent, @NonNull ReferenceQueue<? super EngineResource<?>> queue, boolean isActiveResourceRetentionAllowed) {
            super(referent, queue);
            this.key = Preconditions.checkNotNull(key);
            this.resource = referent.isCacheable() && isActiveResourceRetentionAllowed ? Preconditions.checkNotNull(referent.getResource()) : null;
            this.isCacheable = referent.isCacheable();
        }

        void reset() {
            this.resource = null;
            this.clear();
        }
    }

    @VisibleForTesting
    static interface DequeuedResourceCallback {
        public void onResourceDequeued();
    }
}

