/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;

public class ActiveStateDrawable
extends Drawable {
    private final RectF roundRect = new RectF();
    private final Paint paint = new Paint();
    private final int stateColor;
    private final int strokeColor;
    private final float strokeWidth;

    public ActiveStateDrawable(int stateColor, int strokeColor, float strokeWidth) {
        this.stateColor = stateColor;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.paint.setAntiAlias(true);
    }

    public void draw(Canvas canvas) {
        this.roundRect.set(this.getBounds());
        this.roundRect.inset(this.strokeWidth, this.strokeWidth);
        this.paint.setColor(this.stateColor);
        this.paint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(this.roundRect, (float)(canvas.getHeight() / 2), (float)(canvas.getHeight() / 2), this.paint);
        this.paint.setColor(this.strokeColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.strokeWidth);
        canvas.drawRoundRect(this.roundRect, (float)(canvas.getHeight() / 2), (float)(canvas.getHeight() / 2), this.paint);
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }
}

