/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.views.PartMetadataFormatter;
import io.intercom.android.sdk.views.holder.BlocksPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.com.bumptech.glide.RequestManager;
import java.util.List;

public class PartViewHolder
extends BlocksPartViewHolder {
    private final int viewType;
    private final TextView metaData;
    private final TextView attribution;
    private final PartMetadataFormatter partMetadataFormatter;
    private final Provider<AppConfig> appConfigProvider;
    private final RequestManager requestManager;
    private ViewGroup blocks;

    public PartViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, PartMetadataFormatter partMetadataFormatter, Provider<AppConfig> appConfigProvider, RequestManager requestManager) {
        super(itemView, conversationListener, clipboardManager);
        this.viewType = viewType;
        this.partMetadataFormatter = partMetadataFormatter;
        this.appConfigProvider = appConfigProvider;
        this.requestManager = requestManager;
        this.metaData = (TextView)itemView.findViewById(R.id.metadata);
        this.attribution = (TextView)itemView.findViewById(R.id.attribution);
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        boolean shouldConcatenate = this.shouldConcatenate(part, this.getAdapterPosition());
        this.blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, blocksLayout);
        this.setupHolderBackground(this.viewType, part, shouldConcatenate, this.requestManager);
        this.setupMetaData(this.viewType, part);
        this.setupAttribution(part);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, (View)this.cellLayout, this.blocks);
        if (this.bubble != null) {
            this.bubble.setExpanded(this.shouldExpand(part), false);
        }
    }

    private boolean shouldExpand(Part part) {
        return this.isSelectedPart(part) || this.isLastPart(part) || this.isNextPartTyping(this.getAdapterPosition());
    }

    @VisibleForTesting
    boolean isSelectedPart(Part part) {
        return part == this.conversationListener.getSelectedPart();
    }

    @VisibleForTesting
    boolean isLastPart(Part part) {
        return part == this.conversationListener.getPart(this.conversationListener.getCount() - 1) && !"admin_is_typing_style".equals(part.getMessageStyle());
    }

    @VisibleForTesting
    boolean isNextPartTyping(int adapterPosition) {
        if (adapterPosition == -1) {
            return false;
        }
        int nextPos = adapterPosition + 1;
        return nextPos <= this.conversationListener.getCount() - 1 && "admin_is_typing_style".equals(this.conversationListener.getPart(nextPos).getMessageStyle());
    }

    private void setupHolderBackground(int type, Part conversationPart, boolean shouldConcatenate, RequestManager requestManager) {
        this.setBubbleBackground(conversationPart, (View)this.blocks, type);
        if (this.networkAvatar != null) {
            if (shouldConcatenate) {
                this.networkAvatar.setVisibility(4);
            } else if (type == 1 || type == 5 || type == 4) {
                this.showAvatar(conversationPart.getParticipant(), this.networkAvatar, this.appConfigProvider.get(), requestManager);
            }
        }
    }

    public void onClick(View v) {
        int adapterPosition = this.getAdapterPosition();
        if (adapterPosition != -1) {
            this.conversationListener.onPartClicked(adapterPosition, this);
        }
    }

    public void setExpanded(boolean expanded) {
        if (this.bubble != null) {
            this.bubble.setExpanded(expanded, true);
        }
    }

    private void setupMetaData(int type, Part conversationPart) {
        boolean isLastItem;
        if (this.metaData == null) {
            return;
        }
        boolean bl = isLastItem = conversationPart == this.conversationListener.getPart(this.conversationListener.getCount() - 1);
        if (type == 2 || type == 3) {
            this.metaData.setVisibility(4);
            this.metaData.setHeight(ScreenUtils.dpToPx((float)10.0f, (Context)this.metaData.getContext()));
        } else {
            this.metaData.setText((CharSequence)this.partMetadataFormatter.getMetadataString(conversationPart, isLastItem, this.metaData.getResources()));
            if (Part.MessageState.UPLOAD_FAILED == conversationPart.getMessageState()) {
                this.metaData.setCompoundDrawablesWithIntrinsicBounds(R.drawable.intercom_message_error, 0, 0, 0);
            } else {
                this.metaData.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            }
        }
    }

    private void setupAttribution(Part conversationPart) {
        if (this.attribution == null) {
            return;
        }
        if (this.shouldShowAttribution(conversationPart)) {
            CharSequence attributionText = Phrase.from(this.metaData.getContext(), R.string.intercom_gif_attribution).put("providername", conversationPart.getBlocks().get(0).getAttribution()).format();
            this.attribution.setVisibility(0);
            this.attribution.setText(attributionText);
        } else {
            this.attribution.setVisibility(8);
        }
    }

    private boolean shouldShowAttribution(Part part) {
        return this.isSingleImagePart(part) && !TextUtils.isEmpty((CharSequence)part.getBlocks().get(0).getAttribution()) && part.getMessageState().equals((Object)Part.MessageState.NORMAL);
    }

    private boolean shouldConcatenate(Part conversationPart, int position) {
        if (position == -1) {
            return false;
        }
        if (position + 1 < this.conversationListener.getCount()) {
            Part nextPart = this.conversationListener.getPart(position + 1);
            return Part.shouldConcatenate(conversationPart, nextPart);
        }
        return false;
    }

    private void setBubbleBackground(Part conversationPart, View blocks, int type) {
        int pLeft = blocks.getPaddingLeft();
        int pRight = blocks.getPaddingRight();
        int pTop = blocks.getPaddingTop();
        int pBottom = blocks.getPaddingBottom();
        if (this.isSingleImagePart(conversationPart) || this.isSingleCardPart(conversationPart)) {
            this.cellLayout.setBackgroundColor(0);
            this.cellLayout.setPadding(0, 0, 0, 0);
            pBottom = 0;
            pTop = 0;
        } else {
            Context context = this.cellLayout.getContext();
            int cellPadding = (int)context.getResources().getDimension(R.dimen.intercom_cell_horizontal_padding);
            this.cellLayout.setPadding(cellPadding, 0, cellPadding, 0);
            Drawable bubbleBackground = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_bubble_background);
            if (!conversationPart.isAdmin() && type != 4) {
                AppConfig appConfig = this.appConfigProvider.get();
                bubbleBackground.setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
            }
            BackgroundUtils.setBackground((View)this.cellLayout, bubbleBackground);
        }
        blocks.setPadding(pLeft, pTop, pRight, pBottom);
    }

    private boolean isSingleImagePart(Part part) {
        List<Block> blocks = part.getBlocks();
        if (blocks.size() != 1) {
            return false;
        }
        BlockType blockType = blocks.get(0).getType();
        return blockType == BlockType.LOCALIMAGE || blockType == BlockType.IMAGE;
    }

    @VisibleForTesting
    boolean isSingleCardPart(Part part) {
        List<Block> blocks = part.getBlocks();
        if (blocks.size() != 1) {
            return false;
        }
        Block block = blocks.get(0);
        return block.getType() == BlockType.MESSENGERCARD && !TextUtils.isEmpty((CharSequence)block.getFallbackUrl());
    }
}

