/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.MessengerCardBlock;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewPresenter;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.commons.utilities.HtmlCompat;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;

public class MessengerCard
implements MessengerCardBlock {
    private final Provider<AppConfig> appConfigProvider;
    private final Gson gson;
    private final Bus bus;
    private final MetricTracker metricTracker;
    private final String conversationId;

    public MessengerCard(Provider<AppConfig> appConfigProvider, Gson gson, Bus bus, MetricTracker metricTracker, String conversationId) {
        this.appConfigProvider = appConfigProvider;
        this.gson = gson;
        this.bus = bus;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View addCard(String text, String fallbackUrl, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        if (TextUtils.isEmpty((CharSequence)fallbackUrl)) {
            return this.textFallback(text, parent);
        }
        Context context = parent.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        FrameLayout rootLayout = (FrameLayout)layoutInflater.inflate(R.layout.intercom_messenger_card_block, parent, false);
        ProgressBar loadingView = (ProgressBar)rootLayout.findViewById(R.id.loading_view);
        loadingView.getIndeterminateDrawable().setColorFilter(this.appConfigProvider.get().getBaseColor(), PorterDuff.Mode.SRC_IN);
        CardWebView webView = (CardWebView)rootLayout.findViewById(R.id.messenger_card_web_view);
        MessengerCardWebViewPresenter presenter = new MessengerCardWebViewPresenter(webView, (View)loadingView, fallbackUrl, this.bus, this.appConfigProvider.get().getBaseColor(), this.gson, this.metricTracker, this.conversationId);
        presenter.setUpWebView();
        webView.loadUrl(fallbackUrl);
        return rootLayout;
    }

    private View textFallback(String text, ViewGroup parent) {
        int baseColor = this.appConfigProvider.get().getBaseColor();
        ParagraphView textView = new ParagraphView(parent.getContext(), StyleType.ADMIN, BlockAlignment.LEFT, baseColor);
        textView.setText((CharSequence)HtmlCompat.fromHtml((String)text));
        return textView;
    }
}

