/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.TargetApi;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.com.squareup.otto.Bus;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

class ConversationWebViewClient
extends WebViewClient {
    public static final String UPLOAD_FILE_PATH = "filePath";
    public static final String UPLOAD_MIME_TYPE = "mimeType";
    private final JavascriptRunner jsRunner;
    private final Uri webPageUri;
    private final Bus bus;

    ConversationWebViewClient(JavascriptRunner jsRunner, String webPageUrl, Bus bus) {
        this.jsRunner = jsRunner;
        this.webPageUri = Uri.parse((String)webPageUrl);
        this.bus = bus;
    }

    @TargetApi(value=21)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        return this.shouldInterceptRequest(view, request.getUrl().toString());
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (this.isRequestForFavicon(url)) {
            return new WebResourceResponse(null, null, null);
        }
        Uri uri = Uri.parse((String)url);
        if (uri.getHost().equals(this.webPageUri.getHost()) && !TextUtils.isEmpty((CharSequence)uri.getQueryParameter(UPLOAD_FILE_PATH)) && !TextUtils.isEmpty((CharSequence)uri.getQueryParameter(UPLOAD_MIME_TYPE))) {
            try {
                String filePath = uri.getQueryParameter(UPLOAD_FILE_PATH);
                String mimeType = uri.getQueryParameter(UPLOAD_MIME_TYPE);
                File file = new File(filePath);
                return new WebResourceResponse(mimeType, "UTF-8", (InputStream)new BufferedInputStream(new FileInputStream(file)));
            }
            catch (FileNotFoundException exception) {
                return new WebResourceResponse("text/plain", "UTF-8", null);
            }
        }
        return null;
    }

    public void onPageFinished(WebView view, String url) {
        this.jsRunner.runPendingScripts();
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        if (this.isRequestForFavicon(failingUrl)) {
            return;
        }
        Uri uri = Uri.parse((String)failingUrl);
        if (uri.getHost().equals(this.webPageUri.getHost())) {
            this.bus.post((Object)new ConversationFailedEvent());
            this.jsRunner.clearPendingScripts();
        }
    }

    @TargetApi(value=23)
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (TextUtils.isEmpty((CharSequence)url) || this.webPageUri.toString().equals(url)) {
            return false;
        }
        IntentUtils.safelyOpenIntent(view.getContext(), new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
        return true;
    }

    @TargetApi(value=21)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
    }

    private boolean isRequestForFavicon(String url) {
        return url.contains("/favicon.ico");
    }
}

