/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.os.ParcelFileDescriptor;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Option;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class VideoBitmapDecoder
implements ResourceDecoder<ParcelFileDescriptor, Bitmap> {
    public static final long DEFAULT_FRAME = -1L;
    public static final Option<Long> TARGET_FRAME = Option.disk("io.intercom.com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.TargetFrame", -1L, new Option.CacheKeyUpdater<Long>(){
        private final ByteBuffer buffer = ByteBuffer.allocate(8);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(byte[] keyBytes, Long value, MessageDigest messageDigest) {
            messageDigest.update(keyBytes);
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                this.buffer.position(0);
                messageDigest.update(this.buffer.putLong(value).array());
            }
        }
    });
    public static final Option<Integer> FRAME_OPTION = Option.disk("io.intercom.com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.FrameOption", null, new Option.CacheKeyUpdater<Integer>(){
        private final ByteBuffer buffer = ByteBuffer.allocate(4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(byte[] keyBytes, Integer value, MessageDigest messageDigest) {
            if (value == null) {
                return;
            }
            messageDigest.update(keyBytes);
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                this.buffer.position(0);
                messageDigest.update(this.buffer.putInt(value).array());
            }
        }
    });
    private static final MediaMetadataRetrieverFactory DEFAULT_FACTORY = new MediaMetadataRetrieverFactory();
    private final BitmapPool bitmapPool;
    private final MediaMetadataRetrieverFactory factory;

    public VideoBitmapDecoder(Context context) {
        this(Glide.get(context).getBitmapPool());
    }

    public VideoBitmapDecoder(BitmapPool bitmapPool) {
        this(bitmapPool, DEFAULT_FACTORY);
    }

    VideoBitmapDecoder(BitmapPool bitmapPool, MediaMetadataRetrieverFactory factory) {
        this.bitmapPool = bitmapPool;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handles(ParcelFileDescriptor data, Options options) {
        MediaMetadataRetriever retriever = this.factory.build();
        try {
            retriever.setDataSource(data.getFileDescriptor());
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            retriever.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource<Bitmap> decode(ParcelFileDescriptor resource, int outWidth, int outHeight, Options options) throws IOException {
        Bitmap result;
        long frameTimeMicros = options.get(TARGET_FRAME);
        if (frameTimeMicros < 0L && frameTimeMicros != -1L) {
            throw new IllegalArgumentException("Requested frame must be non-negative, or DEFAULT_FRAME, given: " + frameTimeMicros);
        }
        Integer frameOption = options.get(FRAME_OPTION);
        MediaMetadataRetriever mediaMetadataRetriever = this.factory.build();
        try {
            mediaMetadataRetriever.setDataSource(resource.getFileDescriptor());
            result = frameTimeMicros == -1L ? mediaMetadataRetriever.getFrameAtTime() : (frameOption == null ? mediaMetadataRetriever.getFrameAtTime(frameTimeMicros) : mediaMetadataRetriever.getFrameAtTime(frameTimeMicros, frameOption.intValue()));
        }
        finally {
            mediaMetadataRetriever.release();
        }
        resource.close();
        return BitmapResource.obtain(result, this.bitmapPool);
    }

    static class MediaMetadataRetrieverFactory {
        MediaMetadataRetrieverFactory() {
        }

        public MediaMetadataRetriever build() {
            return new MediaMetadataRetriever();
        }
    }
}

