/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.support.v4.util.Pools;
import io.intercom.com.bumptech.glide.load.Encoder;
import io.intercom.com.bumptech.glide.load.ImageHeaderParser;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.ResourceEncoder;
import io.intercom.com.bumptech.glide.load.data.DataRewinder;
import io.intercom.com.bumptech.glide.load.data.DataRewinderRegistry;
import io.intercom.com.bumptech.glide.load.engine.DecodePath;
import io.intercom.com.bumptech.glide.load.engine.LoadPath;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderRegistry;
import io.intercom.com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import io.intercom.com.bumptech.glide.load.resource.transcode.TranscoderRegistry;
import io.intercom.com.bumptech.glide.provider.EncoderRegistry;
import io.intercom.com.bumptech.glide.provider.ImageHeaderParserRegistry;
import io.intercom.com.bumptech.glide.provider.LoadPathCache;
import io.intercom.com.bumptech.glide.provider.ModelToResourceClassCache;
import io.intercom.com.bumptech.glide.provider.ResourceDecoderRegistry;
import io.intercom.com.bumptech.glide.provider.ResourceEncoderRegistry;
import io.intercom.com.bumptech.glide.util.pool.FactoryPools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Registry {
    private final ModelLoaderRegistry modelLoaderRegistry;
    private final EncoderRegistry encoderRegistry;
    private final ResourceDecoderRegistry decoderRegistry;
    private final ResourceEncoderRegistry resourceEncoderRegistry;
    private final DataRewinderRegistry dataRewinderRegistry;
    private final TranscoderRegistry transcoderRegistry;
    private final ImageHeaderParserRegistry imageHeaderParserRegistry;
    private final ModelToResourceClassCache modelToResourceClassCache = new ModelToResourceClassCache();
    private final LoadPathCache loadPathCache = new LoadPathCache();
    private final Pools.Pool<List<Exception>> exceptionListPool = FactoryPools.threadSafeList();

    public Registry() {
        this.modelLoaderRegistry = new ModelLoaderRegistry(this.exceptionListPool);
        this.encoderRegistry = new EncoderRegistry();
        this.decoderRegistry = new ResourceDecoderRegistry();
        this.resourceEncoderRegistry = new ResourceEncoderRegistry();
        this.dataRewinderRegistry = new DataRewinderRegistry();
        this.transcoderRegistry = new TranscoderRegistry();
        this.imageHeaderParserRegistry = new ImageHeaderParserRegistry();
    }

    public <Data> Registry register(Class<Data> dataClass, Encoder<Data> encoder) {
        this.encoderRegistry.add(dataClass, encoder);
        return this;
    }

    public <Data, TResource> Registry append(Class<Data> dataClass, Class<TResource> resourceClass, ResourceDecoder<Data, TResource> decoder) {
        this.decoderRegistry.append(decoder, dataClass, resourceClass);
        return this;
    }

    public <Data, TResource> Registry prepend(Class<Data> dataClass, Class<TResource> resourceClass, ResourceDecoder<Data, TResource> decoder) {
        this.decoderRegistry.prepend(decoder, dataClass, resourceClass);
        return this;
    }

    public <TResource> Registry register(Class<TResource> resourceClass, ResourceEncoder<TResource> encoder) {
        this.resourceEncoderRegistry.add(resourceClass, encoder);
        return this;
    }

    public Registry register(DataRewinder.Factory factory) {
        this.dataRewinderRegistry.register(factory);
        return this;
    }

    public <TResource, Transcode> Registry register(Class<TResource> resourceClass, Class<Transcode> transcodeClass, ResourceTranscoder<TResource, Transcode> transcoder) {
        this.transcoderRegistry.register(resourceClass, transcodeClass, transcoder);
        return this;
    }

    public Registry register(ImageHeaderParser parser) {
        this.imageHeaderParserRegistry.add(parser);
        return this;
    }

    public <Model, Data> Registry append(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<Model, Data> factory) {
        this.modelLoaderRegistry.append(modelClass, dataClass, factory);
        return this;
    }

    public <Model, Data> Registry prepend(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<Model, Data> factory) {
        this.modelLoaderRegistry.prepend(modelClass, dataClass, factory);
        return this;
    }

    public <Model, Data> Registry replace(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<Model, Data> factory) {
        this.modelLoaderRegistry.replace(modelClass, dataClass, factory);
        return this;
    }

    public <Data, TResource, Transcode> LoadPath<Data, TResource, Transcode> getLoadPath(Class<Data> dataClass, Class<TResource> resourceClass, Class<Transcode> transcodeClass) {
        LoadPath<Data, Object, Transcode> result = this.loadPathCache.get(dataClass, resourceClass, transcodeClass);
        if (result == null && !this.loadPathCache.contains(dataClass, resourceClass, transcodeClass)) {
            List decodePaths = this.getDecodePaths(dataClass, resourceClass, transcodeClass);
            result = decodePaths.isEmpty() ? null : new LoadPath<Data, TResource, Transcode>(dataClass, resourceClass, transcodeClass, decodePaths, this.exceptionListPool);
            this.loadPathCache.put(dataClass, resourceClass, transcodeClass, result);
        }
        return result;
    }

    private <Data, TResource, Transcode> List<DecodePath<Data, TResource, Transcode>> getDecodePaths(Class<Data> dataClass, Class<TResource> resourceClass, Class<Transcode> transcodeClass) {
        ArrayList<DecodePath<Data, TResource, Transcode>> decodePaths = new ArrayList<DecodePath<Data, TResource, Transcode>>();
        List<Class<TResource>> registeredResourceClasses = this.decoderRegistry.getResourceClasses(dataClass, resourceClass);
        for (Class<TResource> registeredResourceClass : registeredResourceClasses) {
            List<Class<Transcode>> registeredTranscodeClasses = this.transcoderRegistry.getTranscodeClasses(registeredResourceClass, transcodeClass);
            for (Class<Transcode> registeredTranscodeClass : registeredTranscodeClasses) {
                List<ResourceDecoder<Data, TResource>> decoders = this.decoderRegistry.getDecoders(dataClass, registeredResourceClass);
                ResourceTranscoder<TResource, Transcode> transcoder = this.transcoderRegistry.get(registeredResourceClass, registeredTranscodeClass);
                decodePaths.add(new DecodePath<Data, TResource, Transcode>(dataClass, registeredResourceClass, registeredTranscodeClass, decoders, transcoder, this.exceptionListPool));
            }
        }
        return decodePaths;
    }

    public <Model, TResource, Transcode> List<Class<?>> getRegisteredResourceClasses(Class<Model> modelClass, Class<TResource> resourceClass, Class<Transcode> transcodeClass) {
        List<Class<?>> result = this.modelToResourceClassCache.get(modelClass, resourceClass);
        if (result == null) {
            result = new ArrayList();
            List<Class<?>> dataClasses = this.modelLoaderRegistry.getDataClasses(modelClass);
            for (Class<?> dataClass : dataClasses) {
                List<Class<TResource>> registeredResourceClasses = this.decoderRegistry.getResourceClasses(dataClass, resourceClass);
                for (Class<TResource> registeredResourceClass : registeredResourceClasses) {
                    List<Class<Transcode>> registeredTranscodeClasses = this.transcoderRegistry.getTranscodeClasses(registeredResourceClass, transcodeClass);
                    if (registeredTranscodeClasses.isEmpty() || result.contains(registeredResourceClass)) continue;
                    result.add(registeredResourceClass);
                }
            }
            this.modelToResourceClassCache.put(modelClass, resourceClass, Collections.unmodifiableList(result));
        }
        return result;
    }

    public boolean isResourceEncoderAvailable(Resource<?> resource) {
        return this.resourceEncoderRegistry.get(resource.getResourceClass()) != null;
    }

    public <X> ResourceEncoder<X> getResultEncoder(Resource<X> resource) throws NoResultEncoderAvailableException {
        ResourceEncoder<X> resourceEncoder = this.resourceEncoderRegistry.get(resource.getResourceClass());
        if (resourceEncoder != null) {
            return resourceEncoder;
        }
        throw new NoResultEncoderAvailableException(resource.getResourceClass());
    }

    public <X> Encoder<X> getSourceEncoder(X data) throws NoSourceEncoderAvailableException {
        Encoder<?> encoder = this.encoderRegistry.getEncoder(data.getClass());
        if (encoder != null) {
            return encoder;
        }
        throw new NoSourceEncoderAvailableException(data.getClass());
    }

    public <X> DataRewinder<X> getRewinder(X data) {
        return this.dataRewinderRegistry.build(data);
    }

    public <Model> List<ModelLoader<Model, ?>> getModelLoaders(Model model) {
        List<ModelLoader<Model, ?>> result = this.modelLoaderRegistry.getModelLoaders(model);
        if (result.isEmpty()) {
            throw new NoModelLoaderAvailableException(model);
        }
        return result;
    }

    public List<ImageHeaderParser> getImageHeaderParsers() {
        List<ImageHeaderParser> result = this.imageHeaderParserRegistry.getParsers();
        if (result.isEmpty()) {
            throw new NoImageHeaderParserException();
        }
        return result;
    }

    public static final class NoImageHeaderParserException
    extends MissingComponentException {
        public NoImageHeaderParserException() {
            super("Failed to find image header parser.");
        }
    }

    public static class MissingComponentException
    extends RuntimeException {
        public MissingComponentException(String message) {
            super(message);
        }
    }

    public static class NoSourceEncoderAvailableException
    extends MissingComponentException {
        public NoSourceEncoderAvailableException(Class<?> dataClass) {
            super("Failed to find source encoder for data class: " + dataClass);
        }
    }

    public static class NoResultEncoderAvailableException
    extends MissingComponentException {
        public NoResultEncoderAvailableException(Class<?> resourceClass) {
            super("Failed to find result encoder for resource class: " + resourceClass);
        }
    }

    public static class NoModelLoaderAvailableException
    extends MissingComponentException {
        public NoModelLoaderAvailableException(Object model) {
            super("Failed to find any ModelLoaders for model: " + model);
        }

        public NoModelLoaderAvailableException(Class<?> modelClass, Class<?> dataClass) {
            super("Failed to find any ModelLoaders for model: " + modelClass + " and data: " + dataClass);
        }
    }
}

