/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.PushHandler;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Map;

public class IntercomPushClient {
    private final Twig twig;
    private final PushHandler pushHandler;

    public IntercomPushClient() {
        this(LumberMill.getLogger(), new PushHandler());
    }

    @VisibleForTesting
    IntercomPushClient(Twig twig, PushHandler pushHandler) {
        this.twig = twig;
        this.pushHandler = pushHandler;
    }

    public void sendTokenToIntercom(@NonNull Application application, @NonNull String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            this.twig.e("sendTokenToIntercom() was called with a null or empty token. This user will not receive push notifications until a valid device token is sent.", new Object[0]);
            return;
        }
        Injector.initIfCachedCredentials(application);
        if (Injector.isNotInitialised()) {
            this.twig.w("Token not sent because Intercom is not initialised", new Object[0]);
            return;
        }
        Injector injector = Injector.get();
        if (this.pushHandler.shouldSendDeviceToken((Context)application, token)) {
            this.pushHandler.sendTokenToIntercom((Context)application, token, injector.getApi());
        }
    }

    public void handlePush(@NonNull Application application, @NonNull Bundle message) {
        if (message == null) {
            this.twig.i("The message passed to handlePush() was null.", new Object[0]);
            return;
        }
        if (!PushPayload.create(message).isIntercomPush()) {
            this.twig.i("The message passed to handlePush() was not an Intercom push message.", new Object[0]);
            return;
        }
        Injector.initIfCachedCredentials(application);
        if (Injector.isNotInitialised()) {
            this.twig.w("Push not handled because Intercom is not initialised", new Object[0]);
            return;
        }
        Injector injector = Injector.get();
        Provider<AppConfig> appConfigProvider = injector.getAppConfigProvider();
        Context localisedContext = new ContextLocaliser(appConfigProvider).createLocalisedContext((Context)application);
        boolean appBackgrounded = injector.getStore().state().hostAppState().isBackgrounded();
        SystemNotificationManager systemNotificationManager = injector.getSystemNotificationManager();
        this.pushHandler.handlePush(message, injector.getUserIdentity(), systemNotificationManager, appBackgrounded, localisedContext, injector.getMetricTracker(), injector.getAppConfigProvider().get());
    }

    public void handlePush(@NonNull Application application, @NonNull Map<String, String> message) {
        if (message == null) {
            this.twig.i("The message passed to handlePush() was null.", new Object[0]);
            return;
        }
        this.handlePush(application, this.convertMessageMapToBundle(message));
    }

    public boolean isIntercomPush(@NonNull Bundle message) {
        return message != null && PushPayload.create(message).isIntercomPush();
    }

    public boolean isIntercomPush(@NonNull Map<String, String> message) {
        return message != null && this.isIntercomPush(this.convertMessageMapToBundle(message));
    }

    private Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle(message.size());
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }
}

