/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.net.Uri;
import android.text.TextUtils;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebViewConversationAction {
    private static final String SET_CONVERSATION = "SET_CONVERSATION";
    private static final String CREATE_PART = "CREATE_PART";
    private static final String CREATE_UPLOAD = "CREATE_UPLOAD";
    private static final String PART_CREATED = "PART_CREATED";
    private static final String ADMIN_IS_TYPING = "ADMIN_IS_TYPING";
    private static final String HOST_USER_AGENT = "intercom-android-sdk/4.1.5";
    private final String type;
    private final Map<String, Object> value;

    public WebViewConversationAction(String type, Map<String, Object> value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getValue() {
        return this.value;
    }

    public static WebViewConversationAction setConversation(AppIdentity appIdentity, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider, String conversationId) {
        HashMap<String, Object> value = new HashMap<String, Object>(5);
        value.put("session", WebViewConversationAction.createSession(appIdentity, userIdentity));
        value.put("conversationId", conversationId);
        value.put("locale", appConfigProvider.get().getLocale());
        value.put("appColor", String.format("#%06X", 0xFFFFFF & appConfigProvider.get().getBaseColor()));
        value.put("appName", appConfigProvider.get().getName());
        return new WebViewConversationAction(SET_CONVERSATION, value);
    }

    public static WebViewConversationAction createPart(List<Block.Builder> blockBuilders) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("body", blockBuilders);
        return new WebViewConversationAction(CREATE_PART, value);
    }

    public static WebViewConversationAction createUpload(String fileName, String filePath, String mimeType, int imageWidth, int imageHeight, boolean isAnnotatedImage) {
        Uri.Builder builder = new Uri.Builder();
        builder.appendQueryParameter("filePath", filePath);
        builder.appendQueryParameter("mimeType", mimeType);
        HashMap<String, Object> value = new HashMap<String, Object>(5);
        value.put("mimeType", mimeType);
        value.put("fileName", fileName);
        value.put("fileUrl", builder.build().toString());
        value.put("width", imageWidth);
        value.put("height", imageHeight);
        value.put("isAnnotatedImage", isAnnotatedImage);
        return new WebViewConversationAction(CREATE_UPLOAD, value);
    }

    public static WebViewConversationAction partCreated() {
        return new WebViewConversationAction(PART_CREATED, Collections.emptyMap());
    }

    public static WebViewConversationAction adminIsTyping(String adminId, String firstName, String avatarUrl) {
        HashMap<String, Object> typingValue = new HashMap<String, Object>();
        typingValue.put("adminId", adminId);
        typingValue.put("firstName", firstName);
        typingValue.put("avatarUrl", avatarUrl);
        return new WebViewConversationAction(ADMIN_IS_TYPING, typingValue);
    }

    private static Map<String, String> createSession(AppIdentity appIdentity, UserIdentity userIdentity) {
        HashMap<String, String> session = new HashMap<String, String>();
        session.put("appId", appIdentity.appId());
        session.put("hostUserAgent", HOST_USER_AGENT);
        if (!TextUtils.isEmpty((CharSequence)userIdentity.getUserId())) {
            session.put("userId", userIdentity.getUserId());
        }
        if (!TextUtils.isEmpty((CharSequence)userIdentity.getEmail())) {
            session.put("email", userIdentity.getEmail());
        }
        if (!TextUtils.isEmpty((CharSequence)userIdentity.getAnonymousId())) {
            session.put("userId", userIdentity.getAnonymousId());
        }
        if (!TextUtils.isEmpty((CharSequence)userIdentity.getHmac())) {
            session.put("userHash", userIdentity.getHmac());
        }
        return session;
    }
}

