/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.View;
import io.intercom.com.bumptech.glide.GeneratedAppGlideModule;
import io.intercom.com.bumptech.glide.GlideBuilder;
import io.intercom.com.bumptech.glide.GlideContext;
import io.intercom.com.bumptech.glide.MemoryCategory;
import io.intercom.com.bumptech.glide.Registry;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.gifdecoder.GifDecoder;
import io.intercom.com.bumptech.glide.load.DecodeFormat;
import io.intercom.com.bumptech.glide.load.data.InputStreamRewinder;
import io.intercom.com.bumptech.glide.load.engine.Engine;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.engine.cache.MemoryCache;
import io.intercom.com.bumptech.glide.load.engine.prefill.BitmapPreFiller;
import io.intercom.com.bumptech.glide.load.engine.prefill.PreFillType;
import io.intercom.com.bumptech.glide.load.model.AssetUriLoader;
import io.intercom.com.bumptech.glide.load.model.ByteArrayLoader;
import io.intercom.com.bumptech.glide.load.model.ByteBufferEncoder;
import io.intercom.com.bumptech.glide.load.model.ByteBufferFileLoader;
import io.intercom.com.bumptech.glide.load.model.DataUrlLoader;
import io.intercom.com.bumptech.glide.load.model.FileLoader;
import io.intercom.com.bumptech.glide.load.model.GlideUrl;
import io.intercom.com.bumptech.glide.load.model.MediaStoreFileLoader;
import io.intercom.com.bumptech.glide.load.model.ResourceLoader;
import io.intercom.com.bumptech.glide.load.model.StreamEncoder;
import io.intercom.com.bumptech.glide.load.model.StringLoader;
import io.intercom.com.bumptech.glide.load.model.UnitModelLoader;
import io.intercom.com.bumptech.glide.load.model.UriLoader;
import io.intercom.com.bumptech.glide.load.model.UrlUriLoader;
import io.intercom.com.bumptech.glide.load.model.stream.HttpGlideUrlLoader;
import io.intercom.com.bumptech.glide.load.model.stream.HttpUriLoader;
import io.intercom.com.bumptech.glide.load.model.stream.MediaStoreImageThumbLoader;
import io.intercom.com.bumptech.glide.load.model.stream.MediaStoreVideoThumbLoader;
import io.intercom.com.bumptech.glide.load.model.stream.UrlLoader;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapDrawableDecoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapDrawableEncoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapEncoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.ByteBufferBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.DefaultImageHeaderParser;
import io.intercom.com.bumptech.glide.load.resource.bitmap.Downsampler;
import io.intercom.com.bumptech.glide.load.resource.bitmap.StreamBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.bitmap.VideoBitmapDecoder;
import io.intercom.com.bumptech.glide.load.resource.bytes.ByteBufferRewinder;
import io.intercom.com.bumptech.glide.load.resource.file.FileDecoder;
import io.intercom.com.bumptech.glide.load.resource.gif.ByteBufferGifDecoder;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawable;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawableEncoder;
import io.intercom.com.bumptech.glide.load.resource.gif.GifFrameResourceDecoder;
import io.intercom.com.bumptech.glide.load.resource.gif.StreamGifDecoder;
import io.intercom.com.bumptech.glide.load.resource.transcode.BitmapBytesTranscoder;
import io.intercom.com.bumptech.glide.load.resource.transcode.BitmapDrawableTranscoder;
import io.intercom.com.bumptech.glide.load.resource.transcode.GifDrawableBytesTranscoder;
import io.intercom.com.bumptech.glide.manager.ConnectivityMonitorFactory;
import io.intercom.com.bumptech.glide.manager.RequestManagerRetriever;
import io.intercom.com.bumptech.glide.module.GlideModule;
import io.intercom.com.bumptech.glide.module.ManifestParser;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.ImageViewTargetFactory;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TargetApi(value=14)
public class Glide
implements ComponentCallbacks2 {
    private static final String DEFAULT_DISK_CACHE_DIR = "image_manager_disk_cache";
    private static final String TAG = "Glide";
    private static volatile Glide glide;
    private static volatile boolean isInitializing;
    private final Engine engine;
    private final BitmapPool bitmapPool;
    private final MemoryCache memoryCache;
    private final BitmapPreFiller bitmapPreFiller;
    private final GlideContext glideContext;
    private final Registry registry;
    private final ArrayPool arrayPool;
    private final RequestManagerRetriever requestManagerRetriever;
    private final ConnectivityMonitorFactory connectivityMonitorFactory;
    private final List<RequestManager> managers = new ArrayList<RequestManager>();
    private MemoryCategory memoryCategory = MemoryCategory.NORMAL;

    @Nullable
    public static File getPhotoCacheDir(Context context) {
        return Glide.getPhotoCacheDir(context, DEFAULT_DISK_CACHE_DIR);
    }

    @Nullable
    public static File getPhotoCacheDir(Context context, String cacheName) {
        File cacheDir = context.getCacheDir();
        if (cacheDir != null) {
            File result = new File(cacheDir, cacheName);
            if (!(result.mkdirs() || result.exists() && result.isDirectory())) {
                return null;
            }
            return result;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Glide get(Context context) {
        if (glide != null) return glide;
        Class<Glide> clazz = Glide.class;
        synchronized (Glide.class) {
            if (glide != null) return glide;
            Glide.checkAndInitializeGlide(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return glide;
        }
    }

    private static void checkAndInitializeGlide(Context context) {
        if (isInitializing) {
            throw new IllegalStateException("You cannot call Glide.get() in registerComponents(), use the provided Glide instance instead");
        }
        isInitializing = true;
        Glide.initializeGlide(context);
        isInitializing = false;
    }

    @VisibleForTesting
    public static synchronized void init(Glide glide) {
        Glide.glide = glide;
    }

    @VisibleForTesting
    public static synchronized void tearDown() {
        glide = null;
    }

    private static void initializeGlide(Context context) {
        Context applicationContext = context.getApplicationContext();
        GeneratedAppGlideModule annotationGeneratedModule = Glide.getAnnotationGeneratedGlideModules();
        List manifestModules = Collections.emptyList();
        if (annotationGeneratedModule == null || annotationGeneratedModule.isManifestParsingEnabled()) {
            manifestModules = new ManifestParser(applicationContext).parse();
        }
        if (annotationGeneratedModule != null && !annotationGeneratedModule.getExcludedModuleClasses().isEmpty()) {
            Set<Class<?>> excludedModuleClasses = annotationGeneratedModule.getExcludedModuleClasses();
            Iterator iterator = manifestModules.iterator();
            while (iterator.hasNext()) {
                GlideModule current = (GlideModule)iterator.next();
                if (!excludedModuleClasses.contains(current.getClass())) continue;
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("AppGlideModule excludes manifest GlideModule: " + current));
                }
                iterator.remove();
            }
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            for (GlideModule glideModule : manifestModules) {
                Log.d((String)TAG, (String)("Discovered GlideModule from manifest: " + glideModule.getClass()));
            }
        }
        RequestManagerRetriever.RequestManagerFactory factory = annotationGeneratedModule != null ? annotationGeneratedModule.getRequestManagerFactory() : null;
        GlideBuilder builder = new GlideBuilder().setRequestManagerFactory(factory);
        for (GlideModule module : manifestModules) {
            module.applyOptions(applicationContext, builder);
        }
        if (annotationGeneratedModule != null) {
            annotationGeneratedModule.applyOptions(applicationContext, builder);
        }
        Glide glide = builder.build(applicationContext);
        for (GlideModule module : manifestModules) {
            module.registerComponents(applicationContext, glide, glide.registry);
        }
        if (annotationGeneratedModule != null) {
            annotationGeneratedModule.registerComponents(applicationContext, glide, glide.registry);
        }
        context.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)glide);
        Glide.glide = glide;
    }

    @Nullable
    private static GeneratedAppGlideModule getAnnotationGeneratedGlideModules() {
        GeneratedAppGlideModule result = null;
        try {
            Class<?> clazz = Class.forName("io.intercom.com.bumptech.glide.GeneratedAppGlideModuleImpl");
            result = (GeneratedAppGlideModule)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Failed to find GeneratedAppGlideModule. You should include an annotationProcessor compile dependency on com.github.bumptech.glide:glide:compiler in your application and a @GlideModule annotated AppGlideModule implementation or LibraryGlideModules will be silently ignored");
            }
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("GeneratedAppGlideModuleImpl is implemented incorrectly. If you've manually implemented this class, remove your implementation. The Annotation processor will generate a correct implementation.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("GeneratedAppGlideModuleImpl is implemented incorrectly. If you've manually implemented this class, remove your implementation. The Annotation processor will generate a correct implementation.", e);
        }
        return result;
    }

    @TargetApi(value=14)
    Glide(Context context, Engine engine, MemoryCache memoryCache, BitmapPool bitmapPool, ArrayPool arrayPool, RequestManagerRetriever requestManagerRetriever, ConnectivityMonitorFactory connectivityMonitorFactory, int logLevel, RequestOptions defaultRequestOptions, Map<Class<?>, TransitionOptions<?, ?>> defaultTransitionOptions) {
        this.engine = engine;
        this.bitmapPool = bitmapPool;
        this.arrayPool = arrayPool;
        this.memoryCache = memoryCache;
        this.requestManagerRetriever = requestManagerRetriever;
        this.connectivityMonitorFactory = connectivityMonitorFactory;
        DecodeFormat decodeFormat = defaultRequestOptions.getOptions().get(Downsampler.DECODE_FORMAT);
        this.bitmapPreFiller = new BitmapPreFiller(memoryCache, bitmapPool, decodeFormat);
        Resources resources = context.getResources();
        this.registry = new Registry();
        this.registry.register(new DefaultImageHeaderParser());
        Downsampler downsampler = new Downsampler(this.registry.getImageHeaderParsers(), resources.getDisplayMetrics(), bitmapPool, arrayPool);
        ByteBufferGifDecoder byteBufferGifDecoder = new ByteBufferGifDecoder(context, this.registry.getImageHeaderParsers(), bitmapPool, arrayPool);
        this.registry.register(ByteBuffer.class, new ByteBufferEncoder()).register(InputStream.class, new StreamEncoder(arrayPool)).append(ByteBuffer.class, Bitmap.class, new ByteBufferBitmapDecoder(downsampler)).append(InputStream.class, Bitmap.class, new StreamBitmapDecoder(downsampler, arrayPool)).append(ParcelFileDescriptor.class, Bitmap.class, new VideoBitmapDecoder(bitmapPool)).register(Bitmap.class, new BitmapEncoder()).append(ByteBuffer.class, BitmapDrawable.class, new BitmapDrawableDecoder<ByteBuffer>(resources, bitmapPool, new ByteBufferBitmapDecoder(downsampler))).append(InputStream.class, BitmapDrawable.class, new BitmapDrawableDecoder<InputStream>(resources, bitmapPool, new StreamBitmapDecoder(downsampler, arrayPool))).append(ParcelFileDescriptor.class, BitmapDrawable.class, new BitmapDrawableDecoder<ParcelFileDescriptor>(resources, bitmapPool, new VideoBitmapDecoder(bitmapPool))).register(BitmapDrawable.class, new BitmapDrawableEncoder(bitmapPool, new BitmapEncoder())).prepend(InputStream.class, GifDrawable.class, new StreamGifDecoder(this.registry.getImageHeaderParsers(), byteBufferGifDecoder, arrayPool)).prepend(ByteBuffer.class, GifDrawable.class, byteBufferGifDecoder).register(GifDrawable.class, new GifDrawableEncoder()).append(GifDecoder.class, GifDecoder.class, new UnitModelLoader.Factory()).append(GifDecoder.class, Bitmap.class, new GifFrameResourceDecoder(bitmapPool)).register(new ByteBufferRewinder.Factory()).append(File.class, ByteBuffer.class, new ByteBufferFileLoader.Factory()).append(File.class, InputStream.class, new FileLoader.StreamFactory()).append(File.class, File.class, new FileDecoder()).append(File.class, ParcelFileDescriptor.class, new FileLoader.FileDescriptorFactory()).append(File.class, File.class, new UnitModelLoader.Factory()).register(new InputStreamRewinder.Factory(arrayPool)).append(Integer.TYPE, InputStream.class, new ResourceLoader.StreamFactory(resources)).append(Integer.TYPE, ParcelFileDescriptor.class, new ResourceLoader.FileDescriptorFactory(resources)).append(Integer.class, InputStream.class, new ResourceLoader.StreamFactory(resources)).append(Integer.class, ParcelFileDescriptor.class, new ResourceLoader.FileDescriptorFactory(resources)).append(String.class, InputStream.class, new DataUrlLoader.StreamFactory()).append(String.class, InputStream.class, new StringLoader.StreamFactory()).append(String.class, ParcelFileDescriptor.class, new StringLoader.FileDescriptorFactory()).append(Uri.class, InputStream.class, new HttpUriLoader.Factory()).append(Uri.class, InputStream.class, new AssetUriLoader.StreamFactory(context.getAssets())).append(Uri.class, ParcelFileDescriptor.class, new AssetUriLoader.FileDescriptorFactory(context.getAssets())).append(Uri.class, InputStream.class, new MediaStoreImageThumbLoader.Factory(context)).append(Uri.class, InputStream.class, new MediaStoreVideoThumbLoader.Factory(context)).append(Uri.class, InputStream.class, new UriLoader.StreamFactory(context.getContentResolver())).append(Uri.class, ParcelFileDescriptor.class, new UriLoader.FileDescriptorFactory(context.getContentResolver())).append(Uri.class, InputStream.class, new UrlUriLoader.StreamFactory()).append(URL.class, InputStream.class, new UrlLoader.StreamFactory()).append(Uri.class, File.class, new MediaStoreFileLoader.Factory(context)).append(GlideUrl.class, InputStream.class, new HttpGlideUrlLoader.Factory()).append(byte[].class, ByteBuffer.class, new ByteArrayLoader.ByteBufferFactory()).append(byte[].class, InputStream.class, new ByteArrayLoader.StreamFactory()).register(Bitmap.class, BitmapDrawable.class, new BitmapDrawableTranscoder(resources, bitmapPool)).register(Bitmap.class, byte[].class, new BitmapBytesTranscoder()).register(GifDrawable.class, byte[].class, new GifDrawableBytesTranscoder());
        ImageViewTargetFactory imageViewTargetFactory = new ImageViewTargetFactory();
        this.glideContext = new GlideContext(context, this.registry, imageViewTargetFactory, defaultRequestOptions, defaultTransitionOptions, engine, logLevel);
    }

    public BitmapPool getBitmapPool() {
        return this.bitmapPool;
    }

    public ArrayPool getArrayPool() {
        return this.arrayPool;
    }

    public Context getContext() {
        return this.glideContext.getBaseContext();
    }

    ConnectivityMonitorFactory getConnectivityMonitorFactory() {
        return this.connectivityMonitorFactory;
    }

    GlideContext getGlideContext() {
        return this.glideContext;
    }

    public void preFillBitmapPool(PreFillType.Builder ... bitmapAttributeBuilders) {
        this.bitmapPreFiller.preFill(bitmapAttributeBuilders);
    }

    public void clearMemory() {
        Util.assertMainThread();
        this.memoryCache.clearMemory();
        this.bitmapPool.clearMemory();
        this.arrayPool.clearMemory();
    }

    public void trimMemory(int level) {
        Util.assertMainThread();
        this.memoryCache.trimMemory(level);
        this.bitmapPool.trimMemory(level);
        this.arrayPool.trimMemory(level);
    }

    public void clearDiskCache() {
        Util.assertBackgroundThread();
        this.engine.clearDiskCache();
    }

    public RequestManagerRetriever getRequestManagerRetriever() {
        return this.requestManagerRetriever;
    }

    public MemoryCategory setMemoryCategory(MemoryCategory memoryCategory) {
        Util.assertMainThread();
        this.memoryCache.setSizeMultiplier(memoryCategory.getMultiplier());
        this.bitmapPool.setSizeMultiplier(memoryCategory.getMultiplier());
        MemoryCategory oldCategory = this.memoryCategory;
        this.memoryCategory = memoryCategory;
        return oldCategory;
    }

    private static RequestManagerRetriever getRetriever(@Nullable Context context) {
        Preconditions.checkNotNull(context, "You cannot start a load on a not yet attached View or a  Fragment where getActivity() returns null (which usually occurs when getActivity() is called before the Fragment is attached or after the Fragment is destroyed).");
        return Glide.get(context).getRequestManagerRetriever();
    }

    public static RequestManager with(Context context) {
        return Glide.getRetriever(context).get(context);
    }

    public static RequestManager with(Activity activity) {
        return Glide.getRetriever((Context)activity).get(activity);
    }

    public static RequestManager with(FragmentActivity activity) {
        return Glide.getRetriever((Context)activity).get(activity);
    }

    public static RequestManager with(Fragment fragment) {
        return Glide.getRetriever((Context)fragment.getActivity()).get(fragment);
    }

    public static RequestManager with(android.support.v4.app.Fragment fragment) {
        return Glide.getRetriever((Context)fragment.getActivity()).get(fragment);
    }

    public static RequestManager with(View view) {
        return Glide.getRetriever(view.getContext()).get(view);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromManagers(Target<?> target) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            for (RequestManager requestManager : this.managers) {
                if (!requestManager.untrack(target)) continue;
                return;
            }
        }
        throw new IllegalStateException("Failed to remove target from managers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerRequestManager(RequestManager requestManager) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            if (this.managers.contains(requestManager)) {
                throw new IllegalStateException("Cannot register already registered manager");
            }
            this.managers.add(requestManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterRequestManager(RequestManager requestManager) {
        List<RequestManager> list = this.managers;
        synchronized (list) {
            if (!this.managers.contains(requestManager)) {
                throw new IllegalStateException("Cannot register not yet registered manager");
            }
            this.managers.remove(requestManager);
        }
    }

    public void onTrimMemory(int level) {
        this.trimMemory(level);
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
        this.clearMemory();
    }
}

