/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;
import io.intercom.android.sdk.utilities.ViewUtils;

class TeamProfileToolbarBehavior
extends ProfileToolbarBehavior {
    private static final float CHANGE_IN_SCALE = 0.3f;
    private final ViewGroup rootLayout;
    private LinearLayout teamProfiles;
    private ImageView avatarMini1;
    private ImageView avatarMini2;
    private ImageView avatarMini3;
    private TextView bio;
    private TextView officeHours;
    private View separator;
    private View officeHoursBanner;
    private final float translate16dp;

    public TeamProfileToolbarBehavior(ViewGroup rootLayout) {
        super(rootLayout.getContext());
        this.rootLayout = rootLayout;
        this.translate16dp = ScreenUtils.dpToPx((float)16.0f, (Context)rootLayout.getContext());
    }

    private void updateCollapsedAvatars(ViewGroup child, float scrollPercentage) {
        if (this.avatarMini1 == null) {
            this.avatarMini1 = (ImageView)child.findViewById(R.id.intercom_collapsing_team_avatar1);
        }
        if (this.avatarMini2 == null) {
            this.avatarMini2 = (ImageView)child.findViewById(R.id.intercom_collapsing_team_avatar2);
        }
        if (this.avatarMini3 == null) {
            this.avatarMini3 = (ImageView)child.findViewById(R.id.intercom_collapsing_team_avatar3);
        }
        float scale = 0.7f + 0.003f * scrollPercentage;
        this.avatarMini1.setScaleX(scale);
        this.avatarMini2.setScaleX(scale);
        this.avatarMini3.setScaleX(scale);
        this.avatarMini1.setScaleY(scale);
        this.avatarMini2.setScaleY(scale);
        this.avatarMini3.setScaleY(scale);
    }

    private void updateTeamProfile(ViewGroup child, View dependency, float scrollPercentage) {
        if (this.teamProfiles == null) {
            this.teamProfiles = (LinearLayout)child.findViewById(R.id.intercom_team_profiles_layout);
        }
        this.setAlphaAsPercentageOfScroll((View)this.teamProfiles, dependency, 1.0f, false);
        float translationY = this.translate16dp / 100.0f * scrollPercentage;
        this.teamProfiles.setTranslationY((float)((int)Math.max(0.0f, translationY)));
    }

    private void updateCollapsedBio(ViewGroup child, View dependency, float scrollPercentage) {
        if (this.bio == null) {
            this.bio = (TextView)child.findViewById(R.id.intercom_collapsing_team_bio);
        }
        this.setAlphaAsPercentageOfScroll((View)this.bio, dependency, 0.7f, false);
        float translationY = this.translate16dp / 100.0f * scrollPercentage;
        this.bio.setTranslationY((float)((int)Math.max(0.0f, translationY)));
    }

    private void updateOfficeHours(ViewGroup child, View dependency, float scrollPercentage) {
        if (this.officeHours == null) {
            this.officeHours = (TextView)child.findViewById(R.id.intercom_collapsing_office_hours);
        }
        if (this.separator == null) {
            this.separator = child.findViewById(R.id.intercom_team_profile_separator);
        }
        if (this.officeHoursBanner == null) {
            this.officeHoursBanner = child.findViewById(R.id.intercom_office_hours_banner);
        }
        this.setAlphaAsPercentageOfScroll((View)this.officeHours, dependency, 1.0f, false);
        this.setAlphaAsPercentageOfScroll(this.separator, dependency, 0.1f, false);
        this.setAlphaAsPercentageOfScroll(this.officeHoursBanner, dependency, 0.2f, false);
        float translationY = this.translate16dp / 100.0f * scrollPercentage;
        this.officeHours.setTranslationY((float)((int)Math.max(0.0f, translationY)));
        this.separator.setTranslationY((float)((int)Math.max(0.0f, translationY)));
        this.officeHoursBanner.setTranslationY((float)((int)Math.max(0.0f, translationY)));
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        if ((float)appBarLayout.getHeight() <= this.toolbarHeight) {
            return;
        }
        float scrollPercentage = this.getScrollPercentage((View)appBarLayout);
        this.rootLayout.getLayoutParams().height = appBarLayout.getBottom();
        this.updateCollapsedAvatars(this.rootLayout, scrollPercentage);
        this.updateTeamProfile(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.updateCollapsedBio(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.updateOfficeHours(this.rootLayout, (View)appBarLayout, scrollPercentage);
        ViewUtils.requestLayoutIfPossible((View)this.rootLayout);
    }
}

