/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine.bitmap_recycle;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.AttributeStrategy;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.SizeConfigStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LruBitmapPool
implements BitmapPool {
    private static final String TAG = "LruBitmapPool";
    private static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.ARGB_8888;
    private final LruPoolStrategy strategy;
    private final Set<Bitmap.Config> allowedConfigs;
    private final int initialMaxSize;
    private final BitmapTracker tracker;
    private int maxSize;
    private int currentSize;
    private int hits;
    private int misses;
    private int puts;
    private int evictions;

    LruBitmapPool(int maxSize, LruPoolStrategy strategy, Set<Bitmap.Config> allowedConfigs) {
        this.initialMaxSize = maxSize;
        this.maxSize = maxSize;
        this.strategy = strategy;
        this.allowedConfigs = allowedConfigs;
        this.tracker = new NullBitmapTracker();
    }

    public LruBitmapPool(int maxSize) {
        this(maxSize, LruBitmapPool.getDefaultStrategy(), LruBitmapPool.getDefaultAllowedConfigs());
    }

    public LruBitmapPool(int maxSize, Set<Bitmap.Config> allowedConfigs) {
        this(maxSize, LruBitmapPool.getDefaultStrategy(), allowedConfigs);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public synchronized void setSizeMultiplier(float sizeMultiplier) {
        this.maxSize = Math.round((float)this.initialMaxSize * sizeMultiplier);
        this.evict();
    }

    @Override
    public synchronized void put(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap must not be null");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalStateException("Cannot pool recycled bitmap");
        }
        if (!bitmap.isMutable() || this.strategy.getSize(bitmap) > this.maxSize || !this.allowedConfigs.contains(bitmap.getConfig())) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Reject bitmap from pool, bitmap: " + this.strategy.logBitmap(bitmap) + ", is mutable: " + bitmap.isMutable() + ", is allowed config: " + this.allowedConfigs.contains(bitmap.getConfig())));
            }
            bitmap.recycle();
            return;
        }
        int size = this.strategy.getSize(bitmap);
        this.strategy.put(bitmap);
        this.tracker.add(bitmap);
        ++this.puts;
        this.currentSize += size;
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Put bitmap in pool=" + this.strategy.logBitmap(bitmap)));
        }
        this.dump();
        this.evict();
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }

    @Override
    @NonNull
    public Bitmap get(int width, int height, Bitmap.Config config) {
        Bitmap result = this.getDirtyOrNull(width, height, config);
        if (result != null) {
            result.eraseColor(0);
        } else {
            result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        return result;
    }

    @Override
    @NonNull
    public Bitmap getDirty(int width, int height, Bitmap.Config config) {
        Bitmap result = this.getDirtyOrNull(width, height, config);
        if (result == null) {
            result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        return result;
    }

    @TargetApi(value=26)
    private static void assertNotHardwareConfig(Bitmap.Config config) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (config == Bitmap.Config.HARDWARE) {
            throw new IllegalArgumentException("Cannot create a mutable Bitmap with config: " + config + ". Consider setting Downsampler#ALLOW_HARDWARE_CONFIG to false in your RequestOptions and/or in GlideBuilder.setDefaultRequestOptions");
        }
    }

    @Nullable
    private synchronized Bitmap getDirtyOrNull(int width, int height, Bitmap.Config config) {
        LruBitmapPool.assertNotHardwareConfig(config);
        Bitmap result = this.strategy.get(width, height, config != null ? config : DEFAULT_CONFIG);
        if (result == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Missing bitmap=" + this.strategy.logBitmap(width, height, config)));
            }
            ++this.misses;
        } else {
            ++this.hits;
            this.currentSize -= this.strategy.getSize(result);
            this.tracker.remove(result);
            LruBitmapPool.normalize(result);
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Get bitmap=" + this.strategy.logBitmap(width, height, config)));
        }
        this.dump();
        return result;
    }

    private static void normalize(Bitmap bitmap) {
        bitmap.setHasAlpha(true);
        LruBitmapPool.maybeSetPreMultiplied(bitmap);
    }

    @TargetApi(value=19)
    private static void maybeSetPreMultiplied(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            bitmap.setPremultiplied(true);
        }
    }

    @Override
    public void clearMemory() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"clearMemory");
        }
        this.trimToSize(0);
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int level) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("trimMemory, level=" + level));
        }
        if (level >= 40) {
            this.clearMemory();
        } else if (level >= 20) {
            this.trimToSize(this.maxSize / 2);
        }
    }

    private synchronized void trimToSize(int size) {
        while (this.currentSize > size) {
            Bitmap removed = this.strategy.removeLast();
            if (removed == null) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)"Size mismatch, resetting");
                    this.dumpUnchecked();
                }
                this.currentSize = 0;
                return;
            }
            this.tracker.remove(removed);
            this.currentSize -= this.strategy.getSize(removed);
            ++this.evictions;
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Evicting bitmap=" + this.strategy.logBitmap(removed)));
            }
            this.dump();
            removed.recycle();
        }
    }

    private void dump() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.dumpUnchecked();
        }
    }

    private void dumpUnchecked() {
        Log.v((String)TAG, (String)("Hits=" + this.hits + ", misses=" + this.misses + ", puts=" + this.puts + ", evictions=" + this.evictions + ", currentSize=" + this.currentSize + ", maxSize=" + this.maxSize + "\nStrategy=" + this.strategy));
    }

    private static LruPoolStrategy getDefaultStrategy() {
        LruPoolStrategy strategy = Build.VERSION.SDK_INT >= 19 ? new SizeConfigStrategy() : new AttributeStrategy();
        return strategy;
    }

    @TargetApi(value=26)
    private static Set<Bitmap.Config> getDefaultAllowedConfigs() {
        HashSet<Bitmap.Config> configs = new HashSet<Bitmap.Config>();
        configs.addAll(Arrays.asList(Bitmap.Config.values()));
        if (Build.VERSION.SDK_INT >= 19) {
            configs.add(null);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            configs.remove(Bitmap.Config.HARDWARE);
        }
        return Collections.unmodifiableSet(configs);
    }

    private static class NullBitmapTracker
    implements BitmapTracker {
        NullBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap) {
        }

        @Override
        public void remove(Bitmap bitmap) {
        }
    }

    private static class ThrowingBitmapTracker
    implements BitmapTracker {
        private final Set<Bitmap> bitmaps = Collections.synchronizedSet(new HashSet());

        private ThrowingBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap) {
            if (this.bitmaps.contains(bitmap)) {
                throw new IllegalStateException("Can't add already added bitmap: " + bitmap + " [" + bitmap.getWidth() + "x" + bitmap.getHeight() + "]");
            }
            this.bitmaps.add(bitmap);
        }

        @Override
        public void remove(Bitmap bitmap) {
            if (!this.bitmaps.contains(bitmap)) {
                throw new IllegalStateException("Cannot remove bitmap not in tracker");
            }
            this.bitmaps.remove(bitmap);
        }
    }

    private static interface BitmapTracker {
        public void add(Bitmap var1);

        public void remove(Bitmap var1);
    }
}

