/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.data;

import io.intercom.com.bumptech.glide.load.data.DataRewinder;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import io.intercom.com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamRewinder
implements DataRewinder<InputStream> {
    private static final int MARK_LIMIT = 0x500000;
    private final RecyclableBufferedInputStream bufferedStream;

    InputStreamRewinder(InputStream is, ArrayPool byteArrayPool) {
        this.bufferedStream = new RecyclableBufferedInputStream(is, byteArrayPool);
        this.bufferedStream.mark(0x500000);
    }

    @Override
    public InputStream rewindAndGet() throws IOException {
        this.bufferedStream.reset();
        return this.bufferedStream;
    }

    @Override
    public void cleanup() {
        this.bufferedStream.release();
    }

    public static final class Factory
    implements DataRewinder.Factory<InputStream> {
        private final ArrayPool byteArrayPool;

        public Factory(ArrayPool byteArrayPool) {
            this.byteArrayPool = byteArrayPool;
        }

        @Override
        public DataRewinder<InputStream> build(InputStream data) {
            return new InputStreamRewinder(data, this.byteArrayPool);
        }

        @Override
        public Class<InputStream> getDataClass() {
            return InputStream.class;
        }
    }
}

