/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.blocks.BlockTypeNotImplementedException;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.VideoProvider;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.ConversationRating;
import io.intercom.android.sdk.blocks.models.Link;
import io.intercom.android.sdk.blocks.models.LinkList;
import io.intercom.android.sdk.blocks.models.NotificationChannelsCard;
import io.intercom.android.sdk.commons.utilities.HtmlCompat;
import java.util.Locale;

public enum BlockType {
    PARAGRAPH("paragraph"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getParagraph().addParagraph(HtmlCompat.fromHtml(block.getText()), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    HEADING("heading"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getHeading().addHeading(HtmlCompat.fromHtml(block.getText()), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    SUBHEADING("subheading"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getSubheading().addSubheading(HtmlCompat.fromHtml(block.getText()), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    CODE("code"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getCode().addCode(HtmlCompat.fromHtml(block.getText()), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LINK("link"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLink().addLinkBlock(Link.fromBlock(block), isFirstObject, isLastObject, layout);
        }
    }
    ,
    CONVERSATIONRATING("conversationRating"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getConversationRating().addConversationRatingBlock(ConversationRating.fromBlock(block), isFirstObject, isLastObject, layout);
        }
    }
    ,
    NOTIFICATIONCHANNELSCARD("notificationChannelCard"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getNotificationChannelsCard().addNotificationChannelsCardBlock(NotificationChannelsCard.fromBlock(block), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LINKLIST("linkList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLinkList().addLinkListBlock(LinkList.fromBlock(block), isFirstObject, isLastObject, layout);
        }
    }
    ,
    UNORDEREDLIST("unorderedList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getUnorderedList().addUnorderedList(block.getItems(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    ORDEREDLIST("orderedList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getOrderedList().addOrderedList(block.getItems(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    ATTACHMENTLIST("attachmentList"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getAttachmentList().addAttachmentList(block.getAttachments(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    IMAGE("image"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getImage().addImage(block.getUrl(), 12.getUrl(block), block.getWidth(), block.getHeight(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LWR("lwr"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLwr().addLWR(block.getText(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    BUTTON("button"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getButton().addButton(block.getText(), 14.getUrl(block), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    FACEBOOKLIKEBUTTON("facebookLikeButton"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getFacebookButton().addFacebookButton(block.getUrl(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    TWITTERFOLLOWBUTTON("twitterFollowButton"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getTwitterButton().addTwitterButton("http://twitter.com/" + block.getUsername(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    VIDEO("video"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getVideo().addVideo(block.getEmbedUrl(), VideoProvider.videoValueOf(block.getProvider()), block.getId(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LOCALIMAGE("localImage"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLocalImage().addImage(block.getUrl(), block.getWidth(), block.getHeight(), block.getAlign(), isFirstObject, isLastObject, layout);
        }
    }
    ,
    LOCAL_ATTACHMENT("local_attachment"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            return viewHolder.getLocalAttachment().addAttachment(block.getAttachments().get(0), isFirstObject, isLastObject, layout);
        }
    }
    ,
    UNKNOWN("unknown"){

        @Override
        public View generateViewFromBlockAndLayout(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) {
            if (!block.getText().isEmpty() && viewHolder.getParagraph() != null) {
                return PARAGRAPH.generateViewFromBlockAndLayout(viewHolder, block, layout, isFirstObject, isLastObject);
            }
            throw new BlockTypeNotImplementedException();
        }
    };

    private final String serializedName;

    private BlockType(String serializedName) {
        this.serializedName = serializedName;
    }

    abstract View generateViewFromBlockAndLayout(BlocksViewHolder var1, Block var2, ViewGroup var3, boolean var4, boolean var5);

    public String getSerializedName() {
        return this.serializedName;
    }

    public View getView(BlocksViewHolder viewHolder, Block block, ViewGroup layout, boolean isFirstObject, boolean isLastObject) throws BlockTypeNotImplementedException {
        try {
            return this.generateViewFromBlockAndLayout(viewHolder, block, layout, isFirstObject, isLastObject);
        }
        catch (NullPointerException exception) {
            try {
                return UNKNOWN.generateViewFromBlockAndLayout(viewHolder, block, layout, isFirstObject, isLastObject);
            }
            catch (BlockTypeNotImplementedException | NullPointerException e) {
                throw new BlockTypeNotImplementedException();
            }
        }
    }

    protected static String getUrl(Block block) {
        return block.getTrackingUrl().isEmpty() ? block.getLinkUrl() : block.getTrackingUrl();
    }

    public static BlockType typeValueOf(String type) {
        BlockType blockType = UNKNOWN;
        try {
            blockType = BlockType.valueOf(type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return blockType;
    }
}

